@include('includes.admin_header')

<div class="d-flex" id="wrapper">
  <!-- Sidebar -->
  @include('includes.admin_sidebar')

  <!-- Page Content -->

    <!-- Main Content -->
    <div class="container-fluid px-4 py-4">
      <!-- Dashboard Cards -->
      <div class="row g-4 overr">
        <div class="col-md-3">
          <div class="card ttle-wheels shadow-sm">
            <div class="card-body">
              <h6><i class="bi bi-circle me-2"></i>Total Wheels</h6>
              <h4 class="fw-bold">{{ $wheel_count }}</h4>
            </div>
          </div>
        </div>
        <div class="col-md-3">
          <div class="card ttle-tire shadow-sm">
            <div class="card-body">
              <h6><i class="bi bi-record-circle me-2"></i>Total Tires</h6>
              <h4 class="fw-bold">{{ $tire_count }}</h4>
            </div>
          </div>
        </div>
        <div class="col-md-3">
          <div class="card nw-order shadow-sm">
            <div class="card-body">
              <h6><i class="bi bi-cart-check-fill me-2"></i>New Orders</h6>
              <h4 class="fw-bold">{{ $new_order }}</h4>
            </div>
          </div>
        </div>
        <div class="col-md-3">
          <div class="card lw-stock shadow-sm">
            <div class="card-body">
              <h6><i class="bi bi-exclamation-triangle-fill me-2"></i>Low Stock</h6>
              <h4 class="fw-bold">{{ $low_stock }} Items</h4>
            </div>
          </div>
        </div>
      </div>
      <hr />
      <!-- Overview Stats -->
      <div class="row mt-3">
        <div class="col-md-6">
          <div class="card tp-prd shadow-sm">
            <div class="card-header text-white">
              <i class="bi bi-box"></i> Top Products
            </div>
            <ul class="list-group list-group-flush">
                @foreach($top_product as $tp)
                  <li class="list-group-item d-flex justify-content-between">
                    <span title="{{ $tp->product_name }}">{{ character_limit($tp->product_name,50) }}</span> <span class="badge bg-success">{{ $tp->total_qty }} sold</span>
                  </li>
                @endforeach
            </ul>
          </div>
        </div>
        <div class="col-md-6">
          <div class="card tp-prd shadow-sm">
            <div class="card-header text-white">
              <i class="bi bi-clock-history"></i> Recent Orders
            </div>
            <ul class="list-group lsttt list-group-flush">
            @foreach($recent_order as $rp)
              <li class="list-group-item">Order #{{ $rp->order_id }} - {{ $rp->qty }}x {{ $rp->product_category }} - <span class="text-success">{{ $rp->status }}</span></li>
            @endforeach
            </ul>
          </div>
        </div>

        <!-- Product Table -->
        <div class="card btdt mt-3">
          <div class="card-header text-white">
              <div class="row">
                  <div class="col-md-6">Product Management</div>
                  <div class="col-md-6" style="text-align:right;"><a href="{{ url('admin/manage-inventory') }}" style="color:red;font-weight:bold;">View All</a></div>
              </div>
          </div>
          <div class="card-body p-0">
            <table class="table align-middle table-bordered invt">
        <thead class="table-light">
          <tr>
            <th>#</th>
            <th>Description</th>
            <th>Size</th>
            <th>Product Type</th>
            <th>Category</th>
            <th>Stock</th>
            <th>Main Price</th>
            <th>Offer Price</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
          @foreach($productdata as $key => $p)
        <tr>
        <td>{{ $key + 1 }}</td>
        <td><span data-toggle="tooltip" data-placement="top" title="{{ $p->title }}">{{ character_limit($p->title,30) }}</span></td>
        @if($p->category == 'Tire')
        <td>{{ $p->size }}</td>
        @elseif($p->category == 'Wheels')
        <td>{{ $p->rim_size }}</td>
        @else
        <td>NA</td>
        @endif
        <td>{{ $p->product_type }}</td>
        <td><span class="badge @if($p->category == 'Tire') bg-primary @elseif($p->category == 'Wheels') bg-warning @else bg-info @endif"><i
            class="bi bi-circle-fill me-1"></i>{{ $p->category }}</span></td>
        <td>{{ $p->stock_qty }}</td>
        <td>{{ $p->main_price }}</td>
        <td>{{ $p->offer_price }}</td>
        <td>
          <a href="{{ url('/') }}/admin/edit-product/{{ $p->id }}" class="btn btn-sm btn-outline-info"><i
            class="bi bi-pencil"></i></a>
          <button class="btn btn-sm btn-outline-danger" onclick="confirmDelete({{ $p->id }})"><i
            class="bi bi-trash"></i></button>
        </td>
        </tr>
      @endforeach
        </tbody>
      </table>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>
@include('includes.admin_footer')
<script>
  function confirmDelete(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "This action cannot be undone.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {

              $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                var postdata = {
                  "id":id
                }
                  $.ajax({
                      url: '{{ url('/') }}/admin/delete-product',
                      type: 'POST',
                      data: postdata,
                      dataType: 'json',
                      success: function (res) {
                        if(res.status == false)
                        {
                            Swal.fire({
                                title: 'Error!',
                                text: 'Something went wrong',
                                icon: 'warning',
                                confirmButtonText: 'OK'
                            });
                        }
                        else
                        {
                            Swal.fire({
                                title: 'Success!',
                                text: 'Data deleted successfully.',
                                icon: 'success',
                                confirmButtonText: 'OK'
                                }).then((result) => {
                                if (result.isConfirmed) {
                                    location.reload();
                                }
                            });
                        }

                      }
                  });
                
            }
        });
    }
</script>
