@include('includes.admin_header')

<div class="d-flex" id="wrapper">
  <!-- Sidebar -->
  @include('includes.admin_sidebar')

    <!-- Main Content -->
  <div class="container-fluid py-4 px-4 order-s">
        <div class="row">
            <div class="col-md-6">
                <h2 class="mb-4"><i class="bi bi-box2-fill me-2"></i>Dealer</h2>
            </div>
            <div class="col-md-6" style="text-align: right;">
                <a href="{{ url('admin/manage-dealer') }}" class="btn btn-primary">Add new Dealer</a>
            </div>
        </div>
    <!--<div class="d-flex justify-content-between align-items-center mb-4">-->
    <!--  <h2><i class="bi bi-shop me-2"></i>Dealer</h2>-->
    <!--</div>-->
    @if (session('error'))
        <div class="alert alert-danger alert-dismissible">
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                {{ session('error') }}
        </div>
        @endif
        @if (session('success'))
        <div class="alert alert-success alert-dismissible">
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                {{ session('success') }}
        </div>
    @endif
    <!-- Add Dealer Form -->
    <div class="card p-4 mb-4">
      <h5 class="mb-3"><i class="bi bi-plus-circle me-2 text-success"></i>Add New Dealer</h5>
      @if(Request::segment(3))
      <form action="{{ route('update-admin-dealer') }}" method="post" enctype="multipart/form-data">
      <input type="hidden" name="id" value="@if(Request::segment(3)) {{ $dealer_detail->id }}  @endif">
      <input type="hidden" name="hidden_image" value="@if(Request::segment(3)) {{ $dealer_detail->image }}  @endif">
      @else
      <form action="{{ route('save-admin-dealer') }}" method="post" enctype="multipart/form-data">
        @endif
      @csrf
      <div class="row">
        <div class="col-md-12">
            <div class="mb-3">
            <label for="business_name" class="form-label">Business Name</label>
            <input type="text" class="form-control" id="business_name" name="business_name" value="@if(Request::segment(3)){{ $dealer_detail->business_name }}@endif" required />
            </div>
        </div>
        <div class="col-md-4">
            <div class="mb-3">
            <label for="primary_business" class="form-label">What is your primary business?</label>
            <select class="form-control" name="primary_business" id="primary_business">
            <option value="">Select business</option>                 
            <option value="Tire Retailer" @if(Request::segment(3) && $dealer_detail->primary_business == 'Tire Retailer') selected  @endif>Tire Retailer</option>
            <option value="Tire Wholesaler" @if(Request::segment(3) && $dealer_detail->primary_business == 'Tire Wholesaler') selected  @endif>Tire Wholesaler</option>
            <option value="Auto Service" @if(Request::segment(3) && $dealer_detail->primary_business == 'Auto Service') selected  @endif>Auto Service</option>
            </select>
            </div>
        </div>
        <div class="col-md-4">
            <div class="mb-3">
            <label for="company_size" class="form-label">Company size</label>
            <select class="form-control" name="company_size" id="company_size">
            <option value="">Select size</option>                 
            <option value="1 - 5" aria-selected="false" @if(Request::segment(3) && $dealer_detail->company_size == '1 - 5') selected  @endif>1 - 5</option>
            <option value="5 - 10" aria-selected="false" @if(Request::segment(3) && $dealer_detail->company_size == '5 - 10') selected  @endif>5 - 10</option>
            <option value="10 - 25" aria-selected="false" @if(Request::segment(3) && $dealer_detail->company_size == '10 - 25') selected  @endif>10 - 25</option>
            <option value="25 - 50" aria-selected="false" @if(Request::segment(3) && $dealer_detail->company_size == '25 - 50') selected  @endif>25 - 50</option>
            <option value="50 - 100" aria-selected="false" @if(Request::segment(3) && $dealer_detail->company_size == '50 - 100') selected  @endif>50 - 100</option>
            <option value="100+" aria-selected="false" @if(Request::segment(3) && $dealer_detail->company_size == '100+') selected  @endif>100+</option>
            </select>
            </div>
        </div>
        <div class="col-md-4">
            <div class="mb-3">
            <label for="position" class="form-label">Position</label>
            <input type="text" class="form-control" name="position" id="position" value="@if(Request::segment(3)){{ $dealer_detail->position }}@endif" required />
            </div>
        </div>
        <div class="col-md-4">
            <div class="mb-3">
            <label for="name" class="form-label">Name</label>
            <input type="text" class="form-control" name="name" id="name" value="@if(Request::segment(3)){{ $dealer_detail->name }}@endif" required />
            </div>
        </div>
        <div class="col-md-4">
            <div class="mb-3">
            <label for="email" class="form-label">Email address</label>
            <input type="email" class="form-control" name="email" id="email" value="@if(Request::segment(3)){{ $dealer_detail->email }}@endif" required />
            </div>
        </div>
        <div class="col-md-4">
            <div class="mb-3">
            <label for="password" class="form-label">Password</label>
            <input type="text" class="form-control" name="password" id="password" value="@if(Request::segment(3)){{ $dealer_detail->text_password }}@endif" required />
            </div>
        </div>
        <div class="col-md-4">
            <div class="mb-3">
            <label for="phone" class="form-label">Phone Number</label>
            <input type="tel" class="form-control" name="phone" id="phone" value="@if(Request::segment(3)){{ $dealer_detail->phone }}@endif" required />
            </div>
        </div>
        <div class="col-md-4">
            <div class="mb-3">
            <label for="address" class="form-label">Address</label>
            <input type="text" class="form-control" name="address" id="address" value="@if(Request::segment(3)){{ $dealer_detail->address }}@endif" required />
            </div>
        </div>
        <div class="col-md-4">
            <div class="mb-3">
            <label for="city" class="form-label">City</label>
            <input type="text" class="form-control" name="city" id="city" value="@if(Request::segment(3)){{ $dealer_detail->city }}@endif" required />
            </div>
        </div>
        <div class="col-md-4">
            <div class="mb-3">
            <label for="province" class="form-label">Province</label>
            <input type="text" class="form-control" name="province" id="province" value="@if(Request::segment(3)){{ $dealer_detail->province }}@endif" required />
            </div>
        </div>
        <div class="col-md-4">
            <div class="mb-3">
            <label for="postal_code" class="form-label">Postal code</label>
            <input type="text" class="form-control" name="postal_code" id="postal_code" value="@if(Request::segment(3)){{ $dealer_detail->postal_code }}@endif" required />
            </div>
        </div>
        <div class="col-md-4">
            <div class="mb-3">
            <label for="status" class="form-label">Status</label>
            <select class="form-control" name="status" id="status">
            <option value="">Select status</option>                 
            <option value="active" @if(Request::segment(3) && $dealer_detail->status == 'active') selected  @endif>Active</option>
            <option value="inactive" @if(Request::segment(3) && $dealer_detail->status == 'inactive') selected  @endif>Inactive</option>
            </select>
            </div>
        </div>
        <div class="col-md-12">
            <div class="mb-3">
            <label for="message" class="form-label">Message</label>
            <textarea class="form-control" id="message" name="message">@if(Request::segment(3)){{ $dealer_detail->message }}@endif</textarea>
            </div>
        </div>
      </div>
        <div class="mt-3">
        @if(Request::segment(3))
          <button type="submit" class="btns btns-hover"><span><i class="bi bi-save me-1"></i> Update Product</span></button>
          @else
            <button type="submit" class="btns btns-hover"><span><i class="bi bi-save me-1"></i> Save Product</span></button>
          @endif
        </div>
      </form>
    </div>

    <!-- Dealer List -->
    <div class="table-responsive bg-white p-4 rounded shadow-sm">
      <h5 class="mb-3">Dealer List</h5>
      <table class="table align-middle table-bordered invt">
        <thead class="table-light">
          <tr>
            <th>#</th>
            <th>Image</th>
            <th>Name</th>
            <th>Business name</th>
            <th>Primary business</th>
            <th>Email</th>
            <th>Phone</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
           @foreach ($dealerdata as $key=>$d)
          <tr>
            <td>{{ $key+1 }}</td>
            <td><img src="{{ url('/') }}/assets/images/infantry.avif" alt="Wheel" /></td>
            <td>{{ $d->name }}</td>
            <td>{{ $d->business_name }}</td>
            <td>{{ $d->primary_business }}</td>
            <td>{{ $d->email }}</td>
            <td>{{ $d->phone }}</td>
            <td>
              <a href="{{ url('/') }}/admin/edit-dealer/{{ $d->id }}" class="btn btn-sm btn-outline-info"><i class="bi bi-pencil"></i></a>
              <button class="btn btn-sm btn-outline-danger" onclick="confirmDelete({{ $d->id }})"><i class="bi bi-trash"></i></button>
            </td>
          </tr>
          @endforeach
        </tbody>
      </table>
    </div>
  </div>

  </div>
</div>
</div>
@include('includes.admin_footer')
<script>
  $('#productImageInput').on('change', function(event) {
    const file = event.target.files[0];
    if (file) {
        const reader = new FileReader();

        reader.onload = function(e) {
            $('#imagePreview').attr('src', e.target.result).show();
        };

        reader.readAsDataURL(file);
    }
});



function confirmDelete(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "This action cannot be undone.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {

              $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                var postdata = {
                  "id":id
                }
                  $.ajax({
                      url: '{{ url('/') }}/admin/delete-dealer',
                      type: 'POST',
                      data: postdata,
                      dataType: 'json',
                      success: function (res) {
                        if(res.status == false)
                        {
                            Swal.fire({
                                title: 'Error!',
                                text: 'Something went wrong',
                                icon: 'warning',
                                confirmButtonText: 'OK'
                            });
                        }
                        else
                        {
                            Swal.fire({
                                title: 'Success!',
                                text: 'Data deleted successfully.',
                                icon: 'success',
                                confirmButtonText: 'OK'
                                }).then((result) => {
                                if (result.isConfirmed) {
                                    location.href = '{{ url('/') }}/admin/manage-dealer';
                                }
                            });
                        }

                      }
                  });
                
            }
        });
    }

</script>