@include('includes.admin_header')
<style>
  .required {
    color: red;
    font-weight: bold;
  }
</style>
<div class="d-flex" id="wrapper">
  @include('includes.admin_sidebar')
  <div class="container-fluid px-4 py-4">
    <!--<h2 class="mb-4"><i class="bi bi-box2-fill me-2"></i>Inventory Dashboard</h2>-->
            <div class="row">
            <div class="col-md-6">
                <h2 class="mb-4"><i class="bi bi-box2-fill me-2"></i>Inventory Dashboard</h2>
            </div>
            <div class="col-md-6" style="text-align: right;">
                <a href="{{ url('admin/manage-inventory') }}" class="btn btn-primary">Add new Inventory</a>
            </div>
        </div>

    <div class="form-container mb-5">
      @if (session('error'))
      <div class="alert alert-danger alert-dismissible">
      <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
      {{ session('error') }}
      </div>
    @endif
      @if (session('success'))
      <div class="alert alert-success alert-dismissible">
      <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
      {{ session('success') }}
      </div>
    @endif
      <h5 class="mb-3">Add New Inventory Item</h5>
      @if(Request::segment(3))
      <form action="{{ route('update-product') }}" method="post" enctype="multipart/form-data">
      <input type="hidden" name="id" value="{{ $product_detail->id }}">
      <input type="hidden" name="hidden_image" value="{{ $product_detail->image }}">
  @else
      <form action="{{ route('save-product') }}" method="post" enctype="multipart/form-data">
      @endif
          @csrf
          <div class="row g-3">
            <div class="col-md-12">
              <label class="form-label">Product Description <span class="required">*</span></label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-card-text"></i></span>
                <input type="text" class="form-control" name="title"
                  placeholder="e.g. TERCELO TIRES TRANSMATE 4S 107V 235/60R18 ALL WEATHER"
                  value="@if(Request::segment(3)){{ $product_detail->title }}@endif" required>
              </div>
            </div>

            <div class="col-md-4">
              <label class="form-label">SKU</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-card-text"></i></span>
                <input type="text" class="form-control" name="sku" placeholder="e.g. 1010200005431"
                  value="@if(Request::segment(3)){{ $product_detail->sku }}@endif">
              </div>
            </div>
            <div class="col-md-4">
              <label class="form-label">Product Category <span class="required">*</span></label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <select class="form-select" name="product_category" id="product_category" onchange="show_hide_input();" required>
                  <option value="" selected disabled>Select category</option>
                  @foreach ($product_category_list as $pc)
            <option data-product_category="{{ $pc->category }}" value="{{ $pc->id }}" @if(Request::segment(3) && $product_detail->product_category == $pc->id) selected @endif>{{ $pc->category }}</option>
          @endforeach
                </select>
              </div>
            </div>

            <div class="col-md-4">
              <label class="form-label">Vehicle type <span class="required">*</span></label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <select class="form-select" name="vehicle_type" id="vehicle_type" required
                  onchange="get_vehicle_variant();">
                  <option value="" selected disabled>Select Vehicle type</option>
                  @foreach ($vehicle_type_list as $vt)
                <option value="{{ $vt->id }}" @if(Request::segment(3) && $product_detail->vehicle_type == $vt->id)
          selected @endif>{{ $vt->vehicle_type }}</option>
          @endforeach
                </select>
              </div>
            </div>

            <div class="col-md-4">
              <label class="form-label">Product Type <span class="required">*</span></label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <select class="form-select" name="product_type" required>
                  <option value="" selected disabled>Select Product Type</option>
                  @foreach ($product_type_list as $pt)
                <option value="{{ $pt->id }}" @if(Request::segment(3) && $product_detail->product_type == $pt->id)
          selected @endif>{{ $pt->product_type }}</option>
          @endforeach
                </select>
              </div>
            </div>
            <div class="col-md-4">
              <label class="form-label">Main Price ($) <span class="required">*</span></label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-currency-dollar"></i></span>
                <input type="number" class="form-control" name="main_price" placeholder="e.g. 129.99"
                  value="@if(Request::segment(3)){{ $product_detail->main_price }}@endif" required>
              </div>
            </div>
            <div class="col-md-4">
              <label class="form-label">Offer Price ($) <span class="required">*</span></label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-currency-dollar"></i></span>
                <input type="number" class="form-control" name="offer_price" placeholder="e.g. 129.99"
                  value="@if(Request::segment(3)){{ $product_detail->offer_price }}@endif" required>
              </div>
            </div>
            <div class="col-md-4">
              <label class="form-label">Product Status <span class="required">*</span></label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <select class="form-select" name="status" required>
                  <option value="" selected disabled>Select status</option>
                  <option value="active" @if(Request::segment(3) && $product_detail->status == 'active') selected @endif>
                    Active</option>
                  <option value="inactive" @if(Request::segment(3) && $product_detail->status == 'inactive') selected
        @endif>Inactive</option>
                </select>
              </div>
            </div>

            <div class="col-md-4">
              <label class="form-label">Stock Quantity <span class="required">*</span></label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi-card-text"></i></span>
                <input type="number" class="form-control" name="stock_qty" min="0" placeholder="e.g. 1,2,3.."
                  value="@if(Request::segment(3)){{ $product_detail->stock_qty }}@endif" required>
              </div>
            </div>
            <div class="col-md-4">
              <label class="form-label">On Sale <span class="required">*</span></label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <select class="form-select" name="onsale_only" required>
                  <option value="" selected disabled>Select status</option>
                  <option value="Yes" @if(Request::segment(3) && $product_detail->onsale_only == 'Yes') selected @endif>
                    Yes</option>
                  <option value="No" @if(Request::segment(3) && $product_detail->onsale_only == 'No') selected @endif>No
                  </option>
                </select>
              </div>
            </div>
            <div class="col-md-4 tire_content">
              <label class="form-label">Load Index</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <select class="form-select" name="load_index">
                  <option value="" selected disabled>Select Load Index</option>
                  @foreach ($load_index_list as $li)
                <option value="{{ $li->id }}" @if(Request::segment(3) && $product_detail->load_index == $li->id)
          selected @endif>{{ $li->load_index . "(" . $li->load_in_lbs . "LBS - " . $li->load_in_kg . "KG)" }}</option>
          @endforeach
                </select>
              </div>
            </div>
            <div class="col-md-4 tire_content">
              <label class="form-label">Speed Rating</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <select class="form-select" name="speed_rating">
                  <option value="" selected disabled>Select Speed Rating</option>
                  @foreach ($speed_rating_list as $sr)
                <option value="{{ $sr->id }}" @if(Request::segment(3) && $product_detail->speed_rating == $sr->id)
          selected @endif>{{ $sr->rating . "(" . $sr->rating_in_mph . "MPH - " . $sr->rating_in_kmph . "KMPH)" }}
                </option>
          @endforeach
                </select>
              </div>
            </div>
            <div class="col-md-4 wheel_content">
              <label class="form-label">Diameter</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <select class="form-select" name="center_hub_diameter">
                  <option value="" selected disabled>Select Diameter</option>
                  @foreach ($diameter_list as $dl)
            <option value="{{ $dl->id }}" @if(Request::segment(3) && $product_detail->center_hub_diameter == $dl->id) selected @endif>{{ $dl->diameter }}</option>
          @endforeach
                </select>
              </div>
            </div>
            <div class="col-md-4 wheel_content">
              <label class="form-label">Rim Width</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <select class="form-select" name="rim_width_range">
                  <option value="" selected disabled>Select Rim Width</option>
                  @foreach ($rim_width_list as $rw)
                <option value="{{ $rw->id }}" @if(Request::segment(3) && $product_detail->rim_width_range == $rw->id)
          selected @endif>{{ $rw->rim_width }}</option>
          @endforeach
                </select>
              </div>
            </div>

            <div class="col-md-4 tire_content">
              <label class="form-label">Size</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <input type="text" class="form-control" name="size" placeholder="e.g. 235/40ZR19"
                  value="@if(Request::segment(3)){{ $product_detail->size }}@endif">
              </div>
            </div>

            <div class="col-md-4 wheel_content">
              <label class="form-label">Rim Size</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <input type="text" class="form-control" name="rim_size" placeholder="e.g. 19x8.5j"
                  value="@if(Request::segment(3)){{ $product_detail->rim_size }}@endif">
              </div>
            </div>

            <div class="col-md-4 wheel_content">
              <label class="form-label">Bolt Circle</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <input type="text" class="form-control" name="bolt_circle" placeholder="e.g. 5-114.3mm"
                  value="@if(Request::segment(3)){{ $product_detail->bolt_circle }}@endif">
              </div>
            </div>
            <div class="col-md-4 tire_content">
              <label class="form-label">Load Speed</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <input type="text" class="form-control" name="load_speed" placeholder="e.g. 96V"
                  value="@if(Request::segment(3)){{ $product_detail->load_speed }}@endif">
              </div>
            </div>
            <div class="col-md-4 wheel_content">
              <label class="form-label">Offset Distance</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <input type="text" class="form-control" name="offset_distance" placeholder="e.g. 129.99"
                  value="@if(Request::segment(3)){{ $product_detail->offset_distance }}@endif">
              </div>
            </div>
            <div class="col-md-4 tire_content">
              <label class="form-label">Overall Diameter</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <input type="text" class="form-control" name="overall_diameter" placeholder="e.g. 129.99"
                  value="@if(Request::segment(3)){{ $product_detail->overall_diameter }}@endif">
              </div>
            </div>
            <div class="col-md-4 tire_content">
              <label class="form-label">OD Value</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <input type="text" class="form-control" name="od_value" placeholder="e.g. 29.99"
                  value="@if(Request::segment(3)){{ $product_detail->od_value }}@endif">
              </div>
            </div>

            <div class="col-md-4 wheel_content">
              <label class="form-label">Aspect Ratio </label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <input type="text" class="form-control" name="aspect_ratio" placeholder="e.g. 40"
                  value="@if(Request::segment(3)){{ $product_detail->aspect_ratio }}@endif">
              </div>
            </div>
            <div class="col-md-4 tire_content">
              <label class="form-label">Run Flat</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <select class="form-select" name="run_flat">
                  <option value="Yes" @if(Request::segment(3) && $product_detail->run_flat == 'Yes') selected @endif>Yes
                  </option>
                  <option value="No" @if(Request::segment(3) && $product_detail->run_flat == 'No') selected @endif>No
                  </option>
                </select>
              </div>
            </div>

            <div class="col-md-4">
              <label class="form-label">Image </label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <input type="file" class="form-control" name="image[]" id="productImageInput" multiple>
              </div>
            </div>
            <div class="col-md-12">
              <label class="form-label"> </label>
              <div class="input-group">
                @if(!empty($product_detail->image))
                  <i class="bi bi-trash text-denger" style="position: relative;left: 17px;cursor: pointer;" onclick="confirmDelete({{ $product_detail->id }},'product',{{ $product_detail->id }});"></i>
                  <img src="{{ url('/') }}/{{ $product_detail->image }}" id="imagePreview" style="Width:100px;height:100px;margin-right: 5px;">
                  @endif
                @if(Request::segment(3))
                  @foreach($product_image as $pi)
                  <i class="bi bi-trash text-denger" style="position: relative;left: 17px;cursor: pointer;" onclick="confirmDelete({{ $pi->id }},'image',{{ $pi->product_id }});"></i>
                    <img src="{{ url('/') }}/{{ $pi->image }}" id="imagePreview" style="Width:100px;height:100px;margin-right: 5px;">
                  @endforeach
                @endif
              </div>
            </div>

            <div class="col-12 text-end">
              @if(Request::segment(3))
          <button type="submit" class="btns btns-hover"><span><i class="bi bi-save me-1"></i> Update
            Product</span></button>
        @else
          <button type="submit" class="btns btns-hover"><span><i class="bi bi-save me-1"></i> Save
            Product</span></button>
        @endif
            </div>
          </div>
        </form>
    </div>
  </div>

</div>
</div>
@include('includes.admin_footer')

<script>

  @if(Request::segment(3))
    show_hide_input();
  @endif

  function show_hide_input() {
    var selectedOption = $("#product_category").find(':selected');
    var product_category = selectedOption.data('product_category');
    if (product_category == 'Tire') {
      $(".wheel_content").addClass('d-none');
      $(".tire_content").removeClass('d-none');
    }
    else if(product_category == 'Wheels') {
      $(".tire_content").addClass('d-none');
      $(".wheel_content").removeClass('d-none');
    }else{
       $(".wheel_content").removeClass('d-none');
       $(".tire_content").removeClass('d-none');
    }
  }


function confirmDelete(id,type,product_id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "This action cannot be undone.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {

              $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                var postdata = {
                  "id":id,
                  "type":type
                }
                  $.ajax({
                      url: '{{ url('/') }}/admin/delete-product-image',
                      type: 'POST',
                      data: postdata,
                      dataType: 'json',
                      success: function (res) {
                        if(res.status == false)
                        {
                            Swal.fire({
                                title: 'Error!',
                                text: 'Something went wrong',
                                icon: 'warning',
                                confirmButtonText: 'OK'
                            });
                        }
                        else
                        {
                            Swal.fire({
                                title: 'Success!',
                                text: 'Data deleted successfully.',
                                icon: 'success',
                                confirmButtonText: 'OK'
                                }).then((result) => {
                                if (result.isConfirmed) {
                                  location.href = '{{ url('/') }}/admin/edit-product/'+product_id;
                                }
                            });
                        }

                      }
                  });
                
            }
        });
}

</script>