@include('includes.admin_header')

<div class="d-flex" id="wrapper">
  <!-- Sidebar -->
  @include('includes.admin_sidebar')

    <!-- Main Content -->

    <div class="container-fluid px-4 py-4">
    <!--<h2 class="mb-4"><i class="bi bi-box2-fill me-2"></i>Model Dashboard</h2>-->
                                        <div class="row">
            <div class="col-md-6">
                <h2 class="mb-4"><i class="bi bi-box2-fill me-2"></i>Model Dashboard</h2>
            </div>
            <div class="col-md-6" style="text-align: right;">
                <a href="{{ url('admin/manage-model') }}" class="btn btn-primary">Add new Model</a>
            </div>
        </div>

    <!-- Add Inventory Form -->
    <div class="form-container mb-5">
    @if (session('error'))
    <div class="alert alert-danger alert-dismissible">
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            {{ session('error') }}
        </div>
    @endif
    @if (session('success'))
    <div class="alert alert-success alert-dismissible">
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            {{ session('success') }}
        </div>
  @endif
      <h5 class="mb-3">Add New Model</h5>
      @if(Request::segment(3))
      <form action="{{ route('update-model') }}" method="post" enctype="multipart/form-data">
      <input type="hidden" name="id" value="{{ $model_detail->id }}">
      @else
      <form action="{{ route('save-model') }}" method="post" enctype="multipart/form-data">
        @endif
      @csrf
        <div class="row g-3">

        <div class="col-md-6">
            <label class="form-label">Brand</label>
            <div class="input-group">
              <span class="input-group-text"><i class="bi bi-archive"></i></span>
              <select class="form-select" name="brand" required>
                <option value="" selected disabled>Select brand</option>
                @foreach ($branddata as $b)
                <option value="{{ $b->id }}" @if(Request::segment(3) && $model_detail->brand_id == $b->id) selected  @endif>{{ $b->brand_name }}</option>
                @endforeach

              </select>
            </div>
          </div>

          <div class="col-md-6">
              <label class="form-label">Vehicle type <span class="required">*</span></label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <select class="form-select" name="vehicle_type" id="vehicle_type" required
                  onchange="get_vehicle_variant();">
                  <option value="" selected disabled>Select Vehicle type</option>
                  @foreach ($vehicle_type_list as $vt)
                  <option value="{{ $vt->id }}" @if(Request::segment(3) && $product_detail->vehicle_type == $vt->id)
                    selected @endif>{{ $vt->vehicle_type }}</option>
                  @endforeach
                </select>
              </div>
            </div>

          <div class="col-md-6">
            <label class="form-label">Model Name</label>
            <div class="input-group">
              <span class="input-group-text"><i class="bi bi-card-text"></i></span>
              <input type="text" class="form-control" name="model_name" placeholder="e.g. Hundai" value="@if(Request::segment(3)){{ $model_detail->model_name }}@endif" required>
            </div>
          </div>
          

          <div class="col-md-6">
            <label class="form-label">Status</label>
            <div class="input-group">
              <span class="input-group-text"><i class="bi bi-archive"></i></span>
              <select class="form-select" name="status" required>
                <option value="" selected disabled>Select status</option>
                <option value="active" @if(Request::segment(3) && $model_detail->status == 'active') selected  @endif>Active</option>
                <option value="inactive" @if(Request::segment(3) && $model_detail->status == 'inactive') selected  @endif>Inactive</option>
              </select>
            </div>
          </div>

          <div class="col-12 text-end">
          @if(Request::segment(3))
          <button type="submit" class="btns btns-hover"><span><i class="bi bi-save me-1"></i> Update Model</span></button>
          @else
            <button type="submit" class="btns btns-hover"><span><i class="bi bi-save me-1"></i> Save Model</span></button>
          @endif
          </div>
        </div>
      </form>
    </div>

    <!-- Inventory Table -->
    <div class="table-responsive bg-white p-4 rounded shadow-sm">
      <h5 class="mb-3">Current Model</h5>
      <table class="table align-middle table-bordered invt">
        <thead class="table-light">
          <tr>
            <th>#</th>
            <th>Name</th>
            <th>Model</th>
            <th>Brand</th>
            <th>Status</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
           @foreach($modeldata as $key => $p)
          <tr>
            <td>{{ $key+1 }}</td>
            <td>{{ $p->model_name }}</td>
            <td>{{ $p->brand_name }}</td>
            <td>
                <span class="badge @if($p->status == 'active') bg-primary @else bg-warning @endif"><i class="bi bi-circle-fill me-1"></i>{{ $p->status }}</span>
            </td>
            <td>
              <a href="{{ url('/') }}/admin/edit-model/{{ $p->id }}" class="btn btn-sm btn-outline-info"><i class="bi bi-pencil"></i></a>
              <button class="btn btn-sm btn-outline-danger" onclick="confirmDelete({{ $p->id }})"><i class="bi bi-trash"></i></button>
            </td>
          </tr>
          @endforeach
        </tbody>
      </table>
    </div>
  </div>

</div>
</div>
@include('includes.admin_footer')

<script>
  $('#productImageInput').on('change', function(event) {
    const file = event.target.files[0];
    if (file) {
        const reader = new FileReader();

        reader.onload = function(e) {
            $('#imagePreview').attr('src', e.target.result).show();
        };

        reader.readAsDataURL(file);
    }
});



function confirmDelete(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "This action cannot be undone.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {

              $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                var postdata = {
                  "id":id
                }
                  $.ajax({
                      url: '{{ url('/') }}/admin/delete-model',
                      type: 'POST',
                      data: postdata,
                      dataType: 'json',
                      success: function (res) {
                        if(res.status == false)
                        {
                            Swal.fire({
                                title: 'Error!',
                                text: 'Something went wrong',
                                icon: 'warning',
                                confirmButtonText: 'OK'
                            });
                        }
                        else
                        {
                            Swal.fire({
                                title: 'Success!',
                                text: 'Data deleted successfully.',
                                icon: 'success',
                                confirmButtonText: 'OK'
                                }).then((result) => {
                                if (result.isConfirmed) {
                                  location.href = '{{ url('/') }}/admin/manage-model';
                                }
                            });
                        }

                      }
                  });
                
            }
        });
    }

</script>