@include('includes.admin_header')

<div class="d-flex" id="wrapper">
  <!-- Sidebar -->
  @include('includes.admin_sidebar')

    <!-- Main Content -->
    <div class="container-fluid px-4 py-4">
      <!-- Dashboard Cards -->
       <div class="container ">
            <div class="row">
            <div class="col-md-6">
                <h2 class="mb-4"><i class="bi bi-box2-fill me-2"></i>Inventory List</h2>
            </div>
            <div class="col-md-6" style="text-align: right;">
                <a href="{{ url('admin/manage-inventory') }}" class="btn btn-primary">Add new Inventory</a>
            </div>
        </div>
      <div class="row g-4">
            <div class="table-responsive bg-white p-4 rounded shadow-sm">
      <h5 class="mb-3">Current Inventory</h5>
      <table class="table align-middle table-bordered invt">
        <thead class="table-light">
          <tr>
            <th>#</th>
            <th>Description</th>
            <th>SKU</th>
            <th>Size</th>
            <th>Product Type</th>
            <th>Category</th>
            <th>Stock</th>
            <th>Main Price</th>
            <th>Offer Price</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
          @foreach($productdata as $key => $p)
        <tr>
        <td>{{ $key + 1 }}</td>
        <td>{{ $p->title }}</td>
        <td>{{ $p->sku }}</td>
        @if($p->category == 'Tire')
        <td>{{ $p->size }}</td>
        @elseif($p->category == 'Wheels')
        <td>{{ $p->rim_size }}</td>
        @else
        <td>NA</td>
        @endif
        <td>{{ $p->product_type }}</td>
        <td><span class="badge @if($p->category == 'Tire') bg-primary @elseif($p->category == 'Wheels') bg-warning @else bg-info @endif"><i
            class="bi bi-circle-fill me-1"></i>{{ $p->category }}</span></td>
        <td>{{ $p->stock_qty }}</td>
        <td>{{ $p->main_price }}</td>
        <td>{{ $p->offer_price }}</td>
        <td>
          <a href="{{ url('/') }}/admin/edit-product/{{ $p->id }}" class="btn btn-sm btn-outline-info"><i
            class="bi bi-pencil"></i></a>
          <button class="btn btn-sm btn-outline-danger" onclick="confirmDelete({{ $p->id }})"><i
            class="bi bi-trash"></i></button>
        </td>
        </tr>
      @endforeach
        </tbody>
      </table>
    </div>
    </div>
  </div>
</div>
</div>
</div>
@include('includes.admin_footer')
<script>
  function confirmDelete(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "This action cannot be undone.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {

              $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                var postdata = {
                  "id":id
                }
                  $.ajax({
                      url: '{{ url('/') }}/admin/delete-product',
                      type: 'POST',
                      data: postdata,
                      dataType: 'json',
                      success: function (res) {
                        if(res.status == false)
                        {
                            Swal.fire({
                                title: 'Error!',
                                text: 'Something went wrong',
                                icon: 'warning',
                                confirmButtonText: 'OK'
                            });
                        }
                        else
                        {
                            Swal.fire({
                                title: 'Success!',
                                text: 'Data deleted successfully.',
                                icon: 'success',
                                confirmButtonText: 'OK'
                                }).then((result) => {
                                if (result.isConfirmed) {
                                    location.reload();
                                }
                            });
                        }

                      }
                  });
                
            }
        });
    }
</script>
