@include('includes.admin_header')

<div class="d-flex" id="wrapper">
  <!-- Sidebar -->
  @include('includes.admin_sidebar')

    <!-- Main Content -->

    <div class="container-fluid px-4 py-4">
    <!--<h2 class="mb-4"><i class="bi bi-box2-fill me-2"></i>Product Type Dashboard</h2>-->
                    <div class="row">
            <div class="col-md-6">
                <h2 class="mb-4"><i class="bi bi-box2-fill me-2"></i>Product Type Dashboard</h2>
            </div>
            <div class="col-md-6" style="text-align: right;">
                <a href="{{ url('admin/manage-product-type') }}" class="btn btn-primary">Add new Product Type</a>
            </div>
        </div>

    <!-- Add Inventory Form -->
    <div class="form-container mb-5">
    @if (session('error'))
    <div class="alert alert-danger alert-dismissible">
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            {{ session('error') }}
        </div>
    @endif
    @if (session('success'))
    <div class="alert alert-success alert-dismissible">
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            {{ session('success') }}
        </div>
  @endif
      <h5 class="mb-3">Add New Product Type</h5>
      @if(Request::segment(3))
      <form action="{{ route('update-product-type') }}" method="post" enctype="multipart/form-data">
      <input type="hidden" name="id" value="{{ $product_type_detail->id }}">
      @else
      <form action="{{ route('save-product-type') }}" method="post" enctype="multipart/form-data">
        @endif
      @csrf
        <div class="row g-3">
          <!-- Product Name -->
          <div class="col-md-6">
            <label class="form-label">Product Type</label>
            <div class="input-group">
              <span class="input-group-text"><i class="bi bi-card-text"></i></span>
              <input type="text" class="form-control" name="product_type" placeholder="e.g. WINTER TIRE" value="@if(Request::segment(3)){{ $product_type_detail->product_type }}@endif" required>
            </div>
          </div>

          <div class="col-md-6">
            <label class="form-label">Status</label>
            <div class="input-group">
              <span class="input-group-text"><i class="bi bi-archive"></i></span>
              <select class="form-select" name="status" required>
                <option value="" selected disabled>Select status</option>
                <option value="active" @if(Request::segment(3) && $product_type_detail->status == 'active') selected  @endif>Active</option>
                <option value="inactive" @if(Request::segment(3) && $product_type_detail->status == 'inactive') selected  @endif>Inactive</option>
              </select>
            </div>
          </div>

          <div class="col-12 text-end">
          @if(Request::segment(3))
          <button type="submit" class="btns btns-hover"><span><i class="bi bi-save me-1"></i> Update Product Type</span></button>
          @else
            <button type="submit" class="btns btns-hover"><span><i class="bi bi-save me-1"></i> Save Product Type</span></button>
          @endif
          </div>
        </div>
      </form>
    </div>

    <!-- Inventory Table -->
    <div class="table-responsive bg-white p-4 rounded shadow-sm">
      <h5 class="mb-3">Current Product Type</h5>
      <table class="table align-middle table-bordered invt">
        <thead class="table-light">
          <tr>
            <th>#</th>
            <th>Name</th>
            <th>Product Type</th>
            <th>Status</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
           @foreach($producttypedata as $key => $p)
          <tr>
            <td>{{ $key+1 }}</td>
            <td>{{ $p->product_type }}</td>
            <td>
                <span class="badge @if($p->status == 'active') bg-primary @else bg-warning @endif"><i class="bi bi-circle-fill me-1"></i>{{ $p->status }}</span>
            </td>
            <td>
              <a href="{{ url('/') }}/admin/edit-product-type/{{ $p->id }}" class="btn btn-sm btn-outline-info"><i class="bi bi-pencil"></i></a>
              <button class="btn btn-sm btn-outline-danger" onclick="confirmDelete({{ $p->id }})"><i class="bi bi-trash"></i></button>
            </td>
          </tr>
          @endforeach
        </tbody>
      </table>
    </div>
  </div>

</div>
</div>
@include('includes.admin_footer')

<script>
function confirmDelete(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "This action cannot be undone.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {

              $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                var postdata = {
                  "id":id
                }
                  $.ajax({
                      url: '{{ url('/') }}/admin/delete-product-type',
                      type: 'POST',
                      data: postdata,
                      dataType: 'json',
                      success: function (res) {
                        if(res.status == false)
                        {
                            Swal.fire({
                                title: 'Error!',
                                text: 'Something went wrong',
                                icon: 'warning',
                                confirmButtonText: 'OK'
                            });
                        }
                        else
                        {
                            Swal.fire({
                                title: 'Success!',
                                text: 'Data deleted successfully.',
                                icon: 'success',
                                confirmButtonText: 'OK'
                                }).then((result) => {
                                if (result.isConfirmed) {
                                  location.href = '{{ url('/') }}/admin/manage-product-type';
                                }
                            });
                        }

                      }
                  });
                
            }
        });
    }

</script>