@include('includes.admin_header')

<div class="d-flex" id="wrapper">
  <!-- Sidebar -->
  @include('includes.admin_sidebar')

    <!-- Main Content -->
  <div class="container-fluid py-4 px-4 order-s">
    <div class="d-flex justify-content-between align-items-center mb-4">
      <h2><i class="bi bi-receipt me-2"></i>Return Request List</h2>
      <!--<button class="btns btns-hover"><span><i class="bi bi-plus-circle me-1"></i> New Order</span></button>-->
    </div>

    <div class="table-responsive shadow-sm rounded bg-white p-3">
      <table class="table align-middle table-hover">
        <thead class="table-light">
          <tr>
            <th>#</th>
            <th>Account Name</th>
            <th>Account Number</th>
            <th>Name</th>
            <th>Email</th>
            <th>Phone</th>
            <th>VRMA</th>
            <th>Delivery Method</th>
            <th>Address</th>
            <th>Date</th>
            <th>View Product</th>
          </tr>
        </thead>
        <tbody>
        @foreach($returndata as $key => $p)
        <tr>
        <td>{{ $key + 1 }}</td>
        <td>{{ $p->account_name }}</td>
        <td>{{ $p->account_no }}</td>
        <td>{{ $p->first_name." ".$p->last_name }}</td>
        <td>{{ $p->email }}</td>
        <td>{{ $p->phone }}</td>
        <td>{{ $p->vrma }}</td>
        <td>{{ $p->delivery_method }}</td>
        <td>{{ $p->address." ".$p->city." ".$p->postal_code }}</td>
        <td>{{ $p->created_at }}</td>
        <td>
          <button class="btn btn-sm btn-outline-danger" title="View Product" onclick="get_return_product('{{ $p->id }}')"><i
            class="bi bi-eye"></i></button>
        </td>
        </tr>
      @endforeach
        </tbody>
      </table>
    </div>
  </div>
</div>
</div>

<!-- The Modal -->
<div class="modal" id="productModal">
  <div class="modal-dialog" style="max-width: fit-content;">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h4 class="modal-title">Order Product</h4>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <!-- Modal body -->
      <div class="modal-body">
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive shadow-sm rounded bg-white p-3">
                        <table class="table align-middle table-hover">
                            <thead class="table-light">
                              <tr>
                                <th>#</th>
                                <th>Item Number</th>
                                <th>Qty</th>
                                <th>Manufacturer</th>
                                <th>Invoice No</th>
                                <th>Purchase Date</th>
                                <th>Reason</th>
                              </tr>
                            </thead>
                            <tbody id="product_list">
                                
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
      </div>

      <!-- Modal footer -->
      <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Close</button>
      </div>

    </div>
  </div>
</div>


@include('includes.admin_footer')
<script>
function get_return_product(return_id)
{

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        var postdata = {
          "return_id":return_id
        }
        $.ajax({
              url: '{{ url('/') }}/admin/get-return-product',
              type: 'POST',
              data: postdata,
              dataType: 'json',
              success: function (res) {
                    var html=``;
                    var i=1;
                    $.each(res, function(key,val) {
                        html += `<tr>
                                    <td>`+i+`</td>
                                    <td>`+val.item_number+`</td>
                                    <td>`+val.qty+`</td>
                                    <td>`+val.manufacturer+`</td>
                                    <td>`+val.invoice_no+`</td>
                                    <td>`+val.purchase_date+`</td>
                                    <td>`+val.reason+`</td>
                                  </tr>`;
                        i++;
                    });
                    $("#product_list").html(html);
                    $("#productModal").modal('show');

              }
        });
}
</script>
