@include('includes.admin_header')

<div class="d-flex" id="wrapper">
  <!-- Sidebar -->
  @include('includes.admin_sidebar')

    <!-- Main Content -->

    <div class="container-fluid px-4 py-4">
    <!--<h2 class="mb-4"><i class="bi bi-box2-fill me-2"></i>Rim Width Dashboard</h2>-->
                        <div class="row">
            <div class="col-md-6">
                <h2 class="mb-4"><i class="bi bi-box2-fill me-2"></i>Rim Width Dashboard</h2>
            </div>
            <div class="col-md-6" style="text-align: right;">
                <a href="{{ url('admin/manage-rim-width') }}" class="btn btn-primary">Add new Rim Width</a>
            </div>
        </div>

    <!-- Add Inventory Form -->
    <div class="form-container mb-5">
    @if (session('error'))
    <div class="alert alert-danger alert-dismissible">
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            {{ session('error') }}
        </div>
    @endif
    @if (session('success'))
    <div class="alert alert-success alert-dismissible">
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            {{ session('success') }}
        </div>
  @endif
      <h5 class="mb-3">Add New Rim Width</h5>
      @if(Request::segment(3))
      <form action="{{ route('update-rim-width') }}" method="post" enctype="multipart/form-data">
      <input type="hidden" name="id" value="{{ $rim_width_detail->id }}">
      @else
      <form action="{{ route('save-rim-width') }}" method="post" enctype="multipart/form-data">
        @endif
      @csrf
        <div class="row g-3">
          <!-- Product Name -->
          <div class="col-md-12">
            <label class="form-label">Rim Width</label>
            <div class="input-group">
              <span class="input-group-text"><i class="bi bi-card-text"></i></span>
              <input type="text" class="form-control" name="rim_width" placeholder="e.g. 4.5" value="@if(Request::segment(3)){{ $rim_width_detail->rim_width }}@endif" required>
            </div>
          </div>

          <div class="col-12 text-end">
          @if(Request::segment(3))
          <button type="submit" class="btns btns-hover"><span><i class="bi bi-save me-1"></i> Update Rim Width</span></button>
          @else
            <button type="submit" class="btns btns-hover"><span><i class="bi bi-save me-1"></i> Save Rim Width</span></button>
          @endif
          </div>
        </div>
      </form>
    </div>

    <!-- Inventory Table -->
    <div class="table-responsive bg-white p-4 rounded shadow-sm">
      <h5 class="mb-3">Current Rim Width</h5>
      <table class="table align-middle table-bordered invt">
        <thead class="table-light">
          <tr>
            <th>#</th>
            <th>Rim Width</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
           @foreach($rimwidthdata as $key => $p)
          <tr>
            <td>{{ $key+1 }}</td>
            <td>{{ $p->rim_width }}</td>
            <td>
              <a href="{{ url('/') }}/admin/edit-rim-width/{{ $p->id }}" class="btn btn-sm btn-outline-info"><i class="bi bi-pencil"></i></a>
              <button class="btn btn-sm btn-outline-danger" onclick="confirmDelete({{ $p->id }})"><i class="bi bi-trash"></i></button>
            </td>
          </tr>
          @endforeach
        </tbody>
      </table>
    </div>
  </div>

</div>
</div>
@include('includes.admin_footer')

<script>
function confirmDelete(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "This action cannot be undone.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {

              $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                var postdata = {
                  "id":id
                }
                  $.ajax({
                      url: '{{ url('/') }}/admin/delete-rim-width',
                      type: 'POST',
                      data: postdata,
                      dataType: 'json',
                      success: function (res) {
                        if(res.status == false)
                        {
                            Swal.fire({
                                title: 'Error!',
                                text: 'Something went wrong',
                                icon: 'warning',
                                confirmButtonText: 'OK'
                            });
                        }
                        else
                        {
                            Swal.fire({
                                title: 'Success!',
                                text: 'Data deleted successfully.',
                                icon: 'success',
                                confirmButtonText: 'OK'
                                }).then((result) => {
                                if (result.isConfirmed) {
                                  location.href = '{{ url('/') }}/admin/manage-rim-width';
                                }
                            });
                        }

                      }
                  });
                
            }
        });
}

</script>