@include('includes.admin_header')
<style>
  .required {
    color: red;
    font-weight: bold;
  }
</style>
<div class="d-flex" id="wrapper">
  @include('includes.admin_sidebar')
  <div class="container-fluid px-4 py-4">
    <!--<h2 class="mb-4"><i class="bi bi-box2-fill me-2"></i>Vehicle Dashboard</h2>-->
                <div class="row">
            <div class="col-md-6">
                <h2 class="mb-4"><i class="bi bi-box2-fill me-2"></i>Vehicle Dashboard</h2>
            </div>
            <div class="col-md-6" style="text-align: right;">
                <a href="{{ url('admin/manage-vehicle-info') }}" class="btn btn-primary">Add new Vehicle</a>
            </div>
        </div>

    <div class="form-container mb-5">
      @if (session('error'))
      <div class="alert alert-danger alert-dismissible">
      <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
      {{ session('error') }}
      </div>
    @endif
      @if (session('success'))
      <div class="alert alert-success alert-dismissible">
      <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
      {{ session('success') }}
      </div>
    @endif
      <h5 class="mb-3">Add New Vehicle Item</h5>
      @if(Request::segment(3))
      <form action="{{ route('update-vehicle-info') }}" method="post" enctype="multipart/form-data">
      <input type="hidden" name="id" value="{{ $vehicle_info_detail->id }}">
  @else
      <form action="{{ route('save-vehicle-info') }}" method="post" enctype="multipart/form-data">
      @endif
          @csrf
          <div class="row g-3">
            <div class="col-md-4">
              <label class="form-label">Year <span class="required">*</span></label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <select class="form-select" name="year" id="year" required>
                  <option value="" selected disabled>Select Year</option>
                  @for($i = date('Y'); $i >= date('Y') - 70; $i--)
            <option value="{{ $i }}" @if(Request::segment(3) && $vehicle_info_detail->year == $i) selected @endif>
            {{ $i }}</option>
          @endfor
                </select>
              </div>
            </div>
            <div class="col-md-4">
              <label class="form-label">Brand <span class="required">*</span></label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <select class="form-select" name="brand" id="brand" required onchange="getModel(this.value);">
                  <option value="" selected disabled>Select Brand</option>
                  @foreach ($brand_list as $bc)
                <option value="{{ $bc->id }}" @if(Request::segment(3) && $vehicle_info_detail->brand == $bc->id) selected
          @endif>{{ $bc->brand_name }}</option>
          @endforeach
                </select>
              </div>
            </div>
            <div class="col-md-4">
              <label class="form-label">Model <span class="required">*</span></label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <select class="form-select" name="model" id="product_model" required>
                  <option value="" selected disabled>Select model</option>
                </select>
              </div>
            </div>
            <div class="col-md-4">
              <label class="form-label">Vehicle type <span class="required">*</span></label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <select class="form-select" name="vehicle_type" id="vehicle_type" required
                  onchange="get_vehicle_variant();">
                  <option value="" selected disabled>Select Vehicle type</option>
                  @foreach ($vehicle_type_list as $vt)
                <option value="{{ $vt->id }}" @if(Request::segment(3) && $vehicle_info_detail->vehicle_type == $vt->id)
          selected @endif>{{ $vt->vehicle_type }}</option>
          @endforeach
                </select>
              </div>
            </div>
          <div class="col-md-4 tire_content">    
              <label class="form-label">Variant Name</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <input type="text" class="form-control" name="vehicle_variant" placeholder="e.g. X-Zeta" value="@if(Request::segment(3)){{ $vehicle_info_detail->vehicle_variant }}@endif" required>
              </div>
          </div>


            <div class="col-md-4">
              <label class="form-label">Product Status <span class="required">*</span></label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <select class="form-select" name="status" required>
                  <option value="" selected disabled>Select status</option>
                  <option value="active" @if(Request::segment(3) && $vehicle_info_detail->status == 'active') selected @endif>
                    Active</option>
                  <option value="inactive" @if(Request::segment(3) && $vehicle_info_detail->status == 'inactive') selected
        @endif>Inactive</option>
                </select>
              </div>
            </div>

            <div class="col-md-4">
              <label class="form-label">Rim Width</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <select class="form-select" name="rim_width_range">
                  <option value="" selected disabled>Select Rim Width</option>
                  @foreach ($rim_width_list as $rw)
                <option value="{{ $rw->id }}" @if(Request::segment(3) && $vehicle_info_detail->rim_width_range == $rw->id)
          selected @endif>{{ $rw->rim_width_minimum . "x" . $rw->rim_width_maximum . "J" }}</option>
          @endforeach
                </select>
              </div>
            </div>

            <div class="col-md-4 tire_content">
              <label class="form-label">Tire Size</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <input type="text" class="form-control" name="tire_size" placeholder="e.g. 235/40ZR19"
                  value="@if(Request::segment(3)){{ $vehicle_info_detail->size }}@endif">
              </div>
            </div>

            <div class="col-md-4 wheel_content">
              <label class="form-label">Rim Size</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <input type="text" class="form-control" name="rim_size" placeholder="e.g. 19x8.5j"
                  value="@if(Request::segment(3)){{ $vehicle_info_detail->rim_size }}@endif">
              </div>
            </div>

            <div class="col-md-4 wheel_content">
              <label class="form-label">Bolt Circle</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <input type="text" class="form-control" name="bolt_circle" placeholder="e.g. 5-114.3mm"
                  value="@if(Request::segment(3)){{ $vehicle_info_detail->bolt_circle }}@endif">
              </div>
            </div>
            <div class="col-md-4 tire_content">
              <label class="form-label">Load Speed</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <input type="text" class="form-control" name="load_speed" placeholder="e.g. 96V"
                  value="@if(Request::segment(3)){{ $vehicle_info_detail->load_speed }}@endif">
              </div>
            </div>
            <div class="col-md-4 wheel_content">
              <label class="form-label">Offset Distance</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <input type="text" class="form-control" name="offset_distance" placeholder="e.g. 129.99"
                  value="@if(Request::segment(3)){{ $vehicle_info_detail->offset_distance }}@endif">
              </div>
            </div>

            <div class="col-md-4 tire_content">
              <label class="form-label">OD Value</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <input type="text" class="form-control" name="od_value" placeholder="e.g. 29.99"
                  value="@if(Request::segment(3)){{ $vehicle_info_detail->od_value }}@endif">
              </div>
            </div>
            <div class="col-md-4 tire_content">
              <label class="form-label">Inflation Front</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <input type="text" class="form-control" name="inflation_front" placeholder="e.g. 38psi"
                  value="@if(Request::segment(3)){{ $vehicle_info_detail->inflation_front }}@endif">
              </div>
            </div>
            <div class="col-md-4 tire_content">
              <label class="form-label">Inflation Rear</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <input type="text" class="form-control" name="inflation_rear" placeholder="e.g. 35psi"
                  value="@if(Request::segment(3)){{ $vehicle_info_detail->inflation_rear }}@endif">
              </div>
            </div>
          <div class="col-md-4 wheel_content">
              <label class="form-label">Diameter</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <select class="form-select" name="center_hub_diameter">
                  <option value="" selected disabled>Select Diameter</option>
                  @foreach ($diameter_list as $dl)
            <option value="{{ $dl->id }}" @if(Request::segment(3) && $vehicle_info_detail->center_hub_diameter == $dl->id) selected @endif>{{ $dl->diameter }}</option>
          @endforeach
                </select>
              </div>
            </div>


            <div class="col-12 text-end">
              @if(Request::segment(3))
          <button type="submit" class="btns btns-hover"><span><i class="bi bi-save me-1"></i> Update
            Info</span></button>
        @else
          <button type="submit" class="btns btns-hover"><span><i class="bi bi-save me-1"></i> Save
            Info</span></button>
        @endif
            </div>
          </div>
        </form>
    </div>
  </div>

</div>
</div>
@include('includes.admin_footer')

<script>
  @if(Request::segment(3))
    var model = {{ $vehicle_info_detail->model }};
    getModel({{ $vehicle_info_detail->brand }});
    var variant = {{ $vehicle_info_detail->vehicle_variant }};

  @else
    var model = '';
    var variant = '';
  @endif

  $('#productImageInput').on('change', function (event) {
    const file = event.target.files[0];
    if (file) {
      const reader = new FileReader();

      reader.onload = function (e) {
        $(".imgdiv").removeClass('d-none');
        $('#imagePreview').attr('src', e.target.result).show();
      };

      reader.readAsDataURL(file);
    }
  });

  function get_vehicle_variant() {
    $.ajaxSetup({
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
    });
    var postdata = {
      "year": $("#year").val(),
      "brand": $("#brand").val(),
      "model": $("#product_model").val(),
      "vehicle_type": $("#vehicle_type").val(),
    }
    $.ajax({
      url: '{{ url('/') }}/admin/get-vehicle-variant',
      type: 'POST',
      data: postdata,
      dataType: 'json',
      success: function (res) {
        if (res.status == true) {
          var html = `<option value="">Select Vehice variant</option>`;
          $.each(res.data, function (key, val) {
            if (val.id == variant) {
              var selected = 'selected';
            }
            else {
              var selected = '';
            }
            html += `<option value="` + val.id + `" ` + selected + `>` + val.variant + `</option>`;
          });
          $("#vehicle_variant").html(html);
        }
        else {
          Swal.fire({
            title: 'Error!',
            text: 'No variant for selected data',
            icon: 'error',
            confirmButtonText: 'OK'
          });
        }

      }
    });
  }

  function getModel(brand_id) {

    $.ajaxSetup({
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
    });
    var postdata = {
      "brand_id": brand_id
    }
    $.ajax({
      url: '{{ url('/') }}/admin/get-model-by-brand',
      type: 'POST',
      data: postdata,
      dataType: 'json',
      success: function (res) {
        if (res.status == true) {
          var html = `<option value="">Select Model</option>`;
          $.each(res.data, function (key, val) {
            if (val.id == model) {
              var selected = 'selected';
            }
            else {
              var selected = '';
            }
            html += `<option value="` + val.id + `" ` + selected + `>` + val.model_name + `</option>`;
          });
            $("#product_model").html(html);
            @if(Request::segment(3))
              get_vehicle_variant();
            @endif
          }
        else {
          Swal.fire({
            title: 'Error!',
            text: 'No model for selected brand',
            icon: 'error',
            confirmButtonText: 'OK'
          });
        }

      }
    });
  }
</script>