@include('includes.admin_header')

<div class="d-flex" id="wrapper">
  <!-- Sidebar -->
  @include('includes.admin_sidebar')

    <!-- Main Content -->
    <div class="container-fluid px-4 py-4">
      <!-- Dashboard Cards -->
       <div class="container ">
        <div class="d-flex justify-content-between align-items-center mb-4">
          <h2><i class="bi bi-box-seam me-2"></i>Vehicle Dashboard</h2>
          <a href="{{ url('/') }}/admin/manage-vehicle-info" class="btns btns-hover"><span><i class="bi bi-plus-circle me-1"></i>Add New Vehicle</span></a>
        </div>
      <div class="row g-4">
            <div class="table-responsive bg-white p-4 rounded shadow-sm">
      <h5 class="mb-3">Current Vehicle</h5>
      <table class="table align-middle table-bordered invt datatable">
        <thead class="table-light">
          <tr>
            <th>#</th>
            <th>Brand</th>
            <th>Model</th>
            <th>Variant</th>
            <th>Vehicle Type</th>
            <th>Rim Size</th>
            <th>Tire Size</th>
            <th>Load Speed</th>
            <th>OD Value</th>
            <th>Bolt Circle</th>
            <th>Offset Distance</th>
            <th>Inflation</th>
            <th>Diameter</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
          @foreach($vehicle_list as $key => $p)
        <tr>
        <td>{{ $key + 1 }}</td>
        <td>{{ $p->brand_name }}</td>
        <td>{{ $p->model_name }}</td>
        <td>{{ $p->vehicle_variant }}</td>
        <td>{{ $p->vehicle_type }}</td>
        <td>{{ $p->rim_size }}</td>
        <td>{{ $p->size }}</td>
        <td>{{ $p->load_speed }}</td>
        <td>{{ $p->od_value }}</td>
        <td>{{ $p->bolt_circle }}</td>
        <td>{{ $p->offset_distance }}</td>
        <td><p>Front : {{ $p->inflation_front }}</p><p>Rear : {{ $p->inflation_rear }}</p></td>
        <td>{{ $p->diameter }}</td>
        <td>
          <a href="{{ url('/') }}/admin/edit-vehicle-info/{{ $p->id }}" class="btn btn-sm btn-outline-info"><i
            class="bi bi-pencil"></i></a>
          <button class="btn btn-sm btn-outline-danger" onclick="confirmDelete({{ $p->id }})"><i
            class="bi bi-trash"></i></button>
        </td>
        </tr>
      @endforeach
        </tbody>
      </table>
    </div>
    </div>
  </div>
</div>
</div>
</div>
@include('includes.admin_footer')
<script>
  function confirmDelete(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "This action cannot be undone.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {

              $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                var postdata = {
                  "id":id
                }
                  $.ajax({
                      url: '{{ url('/') }}/admin/delete-vehicle-info',
                      type: 'POST',
                      data: postdata,
                      dataType: 'json',
                      success: function (res) {
                        if(res.status == false)
                        {
                            Swal.fire({
                                title: 'Error!',
                                text: 'Something went wrong',
                                icon: 'warning',
                                confirmButtonText: 'OK'
                            });
                        }
                        else
                        {
                            Swal.fire({
                                title: 'Success!',
                                text: 'Data deleted successfully.',
                                icon: 'success',
                                confirmButtonText: 'OK'
                                }).then((result) => {
                                if (result.isConfirmed) {
                                    location.reload();
                                }
                            });
                        }

                      }
                  });
                
            }
        });
    }
</script>
