@include('includes.admin_header')

<div class="d-flex" id="wrapper">
  <!-- Sidebar -->
  @include('includes.admin_sidebar')

    <!-- Main Content -->

    <div class="container-fluid px-4 py-4">
    <!--<h2 class="mb-4"><i class="bi bi-box2-fill me-2"></i>Model Dashboard</h2>-->
                                    <div class="row">
            <div class="col-md-6">
                <h2 class="mb-4"><i class="bi bi-box2-fill me-2"></i>Vehicle Variant Dashboard</h2>
            </div>
            <div class="col-md-6" style="text-align: right;">
                <a href="{{ url('admin/manage-vehicle-info') }}" class="btn btn-primary">Add new Vehicle Variant</a>
            </div>
        </div>

    <!-- Add Inventory Form -->
    <div class="form-container mb-5">
    @if (session('error'))
    <div class="alert alert-danger alert-dismissible">
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            {{ session('error') }}
        </div>
    @endif
    @if (session('success'))
    <div class="alert alert-success alert-dismissible">
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            {{ session('success') }}
        </div>
  @endif
      <h5 class="mb-3">Add New Vehicle Variant</h5>
      @if(Request::segment(3))
      <form action="{{ route('update-vehicle-variant') }}" method="post" enctype="multipart/form-data">
      <input type="hidden" name="id" value="{{ $vehicle_variant_detail->id }}">
      @else
      <form action="{{ route('save-vehicle-variant') }}" method="post" enctype="multipart/form-data">
        @endif
      @csrf
        <div class="row g-3">

        <div class="col-md-4">
            <label class="form-label">Year</label>
            <div class="input-group">
              <span class="input-group-text"><i class="bi bi-archive"></i></span>
              <select class="form-select" name="year" required>
                <option value="" selected disabled>Select Year</option>
                @for($i=date('Y'); $i >= date('Y')-70;$i--)
                  <option value="{{ $i }}" @if(Request::segment(3) && $vehicle_variant_detail->year == $i) selected  @endif>{{ $i }}</option>
                @endfor
              </select>
            </div>
        </div>

        <div class="col-md-4">
            <label class="form-label">Brand</label>
            <div class="input-group">
              <span class="input-group-text"><i class="bi bi-archive"></i></span>
              <select class="form-select" name="brand" required onchange="getModel(this.value);">
                <option value="" selected disabled>Select Brand</option>
                @foreach ($brand_list as $bc)
                  <option value="{{ $bc->id }}" @if(Request::segment(3) && $vehicle_variant_detail->brand == $bc->id) selected  @endif>{{ $bc->brand_name }}</option>
                @endforeach
              </select>
            </div>
        </div>
        <div class="col-md-4">
            <label class="form-label">Model</label>
            <div class="input-group">
              <span class="input-group-text"><i class="bi bi-archive"></i></span>
              <select class="form-select" name="model" id="product_model" required>
                <option value="" selected disabled>Select model</option>
              </select>
            </div>
        </div>

        <div class="col-md-4">
            <label class="form-label">Vehicle Type</label>
            <div class="input-group">
              <span class="input-group-text"><i class="bi bi-archive"></i></span>
              <select class="form-select" name="type" required>
                <option value="" selected disabled>Select Vehicle Type</option>
                @foreach ($vehicle_type as $vt)
                  <option value="{{ $vt->id }}" @if(Request::segment(3) && $vehicle_variant_detail->brand == $vt->id) selected  @endif>{{ $vt->vehicle_type }}</option>
                @endforeach
              </select>
            </div>
        </div>

        <div class="col-md-4 tire_content">    
            <label class="form-label">Variant Name</label>
            <div class="input-group">
              <span class="input-group-text"><i class="bi bi-archive"></i></span>
              <input type="text" class="form-control" name="variant" placeholder="e.g. X-Zeta" value="@if(Request::segment(3)){{ $vehicle_variant_detail->variant }}@endif" required>
            </div>
        </div>

        <div class="col-md-6">
          <label class="form-label">Status</label>
          <div class="input-group">
            <span class="input-group-text"><i class="bi bi-archive"></i></span>
            <select class="form-select" name="status" required>
              <option value="" selected disabled>Select status</option>
              <option value="active" @if(Request::segment(3) && $vehicle_variant_detail->status == 'active') selected  @endif>Active</option>
              <option value="inactive" @if(Request::segment(3) && $vehicle_variant_detail->status == 'inactive') selected  @endif>Inactive</option>
            </select>
          </div>
        </div>


          <div class="col-12 text-end">
          @if(Request::segment(3))
          <button type="submit" class="btns btns-hover"><span><i class="bi bi-save me-1"></i> Update Vehicle Variant</span></button>
          @else
            <button type="submit" class="btns btns-hover"><span><i class="bi bi-save me-1"></i> Save Vehicle Variant</span></button>
          @endif
          </div>
        </div>
      </form>
    </div>

    <!-- Inventory Table -->
    <div class="table-responsive bg-white p-4 rounded shadow-sm">
      <h5 class="mb-3">Current Variant</h5>
      <table class="table align-middle table-bordered invt">
        <thead class="table-light">
          <tr>
            <th>#</th>
            <th>Variant</th>
            <th>Year</th>
            <th>Type</th>
            <th>Brand</th>
            <th>Model</th>
            <th>Status</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
           @foreach($variantdata as $key => $p)
          <tr>
            <td>{{ $key+1 }}</td>
            <td>{{ $p->year }}</td>
            <td>{{ $p->variant }}</td>
            <td>{{ $p->vehicle_type }}</td>
            <td>{{ $p->brand_name }}</td>
            <td>{{ $p->model_name }}</td>
            <td>
                <span class="badge @if($p->status == 'active') bg-primary @else bg-warning @endif"><i class="bi bi-circle-fill me-1"></i>{{ $p->status }}</span>
            </td>
            <td>
              <a href="{{ url('/') }}/admin/edit-vehicle-variant/{{ $p->id }}" class="btn btn-sm btn-outline-info"><i class="bi bi-pencil"></i></a>
              <button class="btn btn-sm btn-outline-danger" onclick="confirmDelete({{ $p->id }})"><i class="bi bi-trash"></i></button>
            </td>
          </tr>
          @endforeach
        </tbody>
      </table>
    </div>
  </div>

</div>
</div>
@include('includes.admin_footer')

<script>
@if(Request::segment(3))
    var model = {{ $vehicle_variant_detail->model }};
    getModel({{ $vehicle_variant_detail->brand }});
@else
    var model = '';
@endif
  $('#productImageInput').on('change', function(event) {
    const file = event.target.files[0];
    if (file) {
        const reader = new FileReader();

        reader.onload = function(e) {
            $('#imagePreview').attr('src', e.target.result).show();
        };

        reader.readAsDataURL(file);
    }
});

function getModel(brand_id) 
{

    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    var postdata = {
      "brand_id":brand_id
    }
    $.ajax({
        url: '{{ url('/') }}/admin/get-model-by-brand',
        type: 'POST',
        data: postdata,
        dataType: 'json',
        success: function (res) {
          if(res.status == true)
          {
              var html = `<option value="">Select Model</option>`;
              $.each(res.data, function (key, val) {
                if(val.id == model)
                {
                    var selected = 'selected';
                }
                else
                {
                    var selected = '';
                }
                html += `<option value="`+val.id+`" `+selected+`>`+val.model_name+`</option>`;
              });
              $("#product_model").html(html);
          }
          else
          {
                Swal.fire({
                  title: 'Error!',
                  text: res.msg,
                  icon: 'error',
                  confirmButtonText: 'OK'
              });
          }

        }
    });
}

function confirmDelete(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "This action cannot be undone.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {

              $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                var postdata = {
                  "id":id
                }
                  $.ajax({
                      url: '{{ url('/') }}/admin/delete-vehicle-variant',
                      type: 'POST',
                      data: postdata,
                      dataType: 'json',
                      success: function (res) {
                        if(res.status == false)
                        {
                            Swal.fire({
                                title: 'Error!',
                                text: 'Something went wrong',
                                icon: 'warning',
                                confirmButtonText: 'OK'
                            });
                        }
                        else
                        {
                            Swal.fire({
                                title: 'Success!',
                                text: 'Data deleted successfully.',
                                icon: 'success',
                                confirmButtonText: 'OK'
                                }).then((result) => {
                                if (result.isConfirmed) {
                                  location.href = '{{ url('/') }}/admin/manage-vehicle-variant';
                                }
                            });
                        }

                      }
                  });
                
            }
        });
    }

</script>