@include('includes.header')
<section class="brodcrum arm" style="background-image:url({{ url('/') }}/assets/images/all-tire.jpg);">
  	<div class="container position-relative py-5">
  		<div class="row">
  			<div class="col-lg-9 m-auto py-4">
			    <div class="text-center hero-text">
			      <h1 class="text-white">All Tires</h1>
			    </div>
  			</div>
  		</div>
  	</div>
  </section>


  <!-- About section -->
  <section class="abs">
  	<div class="container position-relative">
  		<div class="row align-items-center">
  			<div class="col-md-8 col-lg-6">
  				<div class="about-p">
  					<h2>Our Brands</h2>
  					<p>Explore trusted tire brands like Suretrac, Haida, iLink, Kanati, and Yusta, offering durable, high-performance options for all terrains and conditions. From budget-friendly to premium solutions, our tires deliver superior traction, extended tread life, and reliability for every journey.</p>
  				</div>
  			</div>
  			<div class="col-md-4 col-lg-6">
  				<div class="about-img pe-md-3 pe-lg-4">
  					<img src="{{ url('/') }}/assets/images/abab.jpg" class="img-fluid" alt="about img" />
  				</div>
  			</div>
        <div class="col-md-12 mt-4">
          <div class="brands-slider">
            <div class="brand-logo">
              <img src="{{ url('/') }}/assets/images/ab.avif" class="img-fluid" alt="brand" />
            </div>
            <div class="brand-logo">
              <img src="{{ url('/') }}/assets/images/ab1.avif" class="img-fluid" alt="brand" />
            </div>
            <div class="brand-logo">
              <img src="{{ url('/') }}/assets/images/ab2.avif" class="img-fluid" alt="brand" />
            </div>
            <div class="brand-logo">
              <img src="{{ url('/') }}/assets/images/ab3.avif" class="img-fluid" alt="brand" />
            </div>
            <div class="brand-logo">
              <img src="{{ url('/') }}/assets/images/ab4.avif" class="img-fluid" alt="brand" />
            </div>
            <div class="brand-logo">
              <img src="{{ url('/') }}/assets/images/ab3.avif" class="img-fluid" alt="brand" />
            </div>
          </div>
        </div>
  		</div>
  	</div>
  </section>

  <!-- Wheels Section -->
  <section class="wheels-sec" id="suretrac" style="background-color: #464646;">
  	<div class="container">
      <div class="row align-items-center">
        <div class="col-md-4 col-lg-6">
          <div class="about-img pe-md-3 pe-lg-4">
            <img src="{{ url('/') }}/assets/images/Suretrac Tire Group - Wide Climber AWT, .avif" class="img-fluid" alt="about img" />
          </div>
        </div>
        <div class="col-md-8 col-lg-6">
          <div class="about-p">
            <img src="{{ url('/') }}/assets/images/ab.avif" class="img-fluid" alt="about img" />
            <p>Suretrac Tires deliver reliable performance, all-weather versatility, and rugged durability for cars and trucks—trusted by drivers worldwide.</p>
            <a href="#" class="btns btns-hover mt-3 py-2 px-4"><span>Learn More</span></a>
          </div>
        </div>
      </div>
  	</div>
  </section>

  <section class="wheels-sec" id="haida">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-md-12 text-center mb-4">
            <img src="{{ url('/') }}/assets/images/Haida tires logo.avif" class="img-fluid" alt="about img" style="filter: invert(1);" />
        </div>
        <div class="col-md-8 col-lg-6">
          <div class="about-p">
            <h2>Superior Strength, Unbeatable Value</h2>
            <p>Haida Tires offer budget-friendly performance for light trucks and SUVs with all-season and off-road options. Built with premium materials and 3D tread designs, they deliver durability, traction, and confidence on any terrain.</p>
            <a href="#" class="btns btns-hover mt-3 py-2 px-4"><span>Learn More</span></a>
          </div>
        </div>
        <div class="col-md-4 col-lg-6">
          <div class="about-img ps-md-3 ps-lg-4">
            <img src="{{ url('/') }}/assets/images/tiress.jpg" class="img-fluid" alt="about img" />
          </div>
        </div>
      </div>
    </div>
  </section>

  <section class="wheels-sec pt-4" id="kanati" style="background-color: #393939;">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-md-12 text-center mb-4">
            <img src="{{ url('/') }}/assets/images/ab3.avif" class="img-fluid" alt="about img" />
        </div>
        <div class="col-md-4 col-lg-6">
          <div class="about-img pe-md-3 pe-lg-4">
            <img src="{{ url('/') }}/assets/images/trail-ho.avif" class="img-fluid" alt="about img" />
          </div>
        </div>
        <div class="col-md-8 col-lg-6">
          <div class="about-p">
            <h2>Built For Adventure, Made To Last</h2>
            <p>Kanati Tires deliver premium performance and durability for Canada’s diverse roads. With advanced technology, they provide reliable traction, stability, and a smooth ride on any terrain.</p>
            <a href="#" class="btns btns-hover mt-3 py-2 px-4"><span>Learn More</span></a>
          </div>
        </div>
      </div>
    </div>
  </section>

  <section class="wheels-sec pb-0" id="ilink">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-md-12 text-center mb-4">
            <img src="{{ url('/') }}/assets/images/ab2.avif" class="img-fluid" alt="about img" style="filter: invert(1);" />
            <div class="about-p">
              <h2>Innovation, Traction, Reliability</h2>
              <p>iLink Tires deliver innovation, durability, and superior traction at an affordable price, ensuring reliable performance and safety in any condition.</p>
              <a href="#" class="btns btns-hover mt-3 py-2 px-4"><span>Learn More</span></a>
            </div>
          <div class="about-img ">
            <img src="{{ url('/') }}/assets/images/new-banners.avif" class="img-fluid" alt="about img" />
          </div>
        </div>
      </div>
    </div>
  </section>

  <section class="wheels-sec pt-4" id="yusta" style="background-color: #393939;">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-md-12 text-center mb-4">
            <img src="{{ url('/') }}/assets/images/ab4.avif" class="img-fluid" alt="about img" />
        </div>
        <div class="col-md-4 col-lg-6">
          <div class="about-img pe-md-3 pe-lg-4">
            <img src="{{ url('/') }}/assets/images/yusta-tire-group.avif" class="img-fluid" alt="about img" />
          </div>
        </div>
        <div class="col-md-8 col-lg-6">
          <div class="about-p">
            <h2>Driven By Innovation, Built For Confidence</h2>
            <p>Yusta Tires combines innovation, precision, and rigorous quality assurance to deliver durable, high-performance tires for all driving conditions. With a focus on safety and customer satisfaction, Yusta ensures every mile is reliable and enjoyable.</p>
            <a href="#" class="btns btns-hover mt-3 py-2 px-4"><span>Learn More</span></a>
          </div>
        </div>
      </div>
    </div>
  </section>
  
  <!-- Tire Section -->
  <section class="bg-dark book-sc p-0">
          <iframe class="wuksD5" title="Embedded Content" name="htmlComp-iframe" width="100%" height="100%" allow="fullscreen" data-src="" src="https://publuu.com/flip-book/324891/748632"></iframe>
  </section>
  @include('includes.footer')
  <script >
	$(document).ready(function(){
    $('.brands-slider').slick({
      slidesToShow: 5,
      slidesToScroll: 1,
      autoplay: true,
      autoplaySpeed: 0,            // Speed between auto-scrolls
      speed: 4000,                 // Speed of the scroll itself
      cssEase: 'linear',           // Smooth continuous scrolling
      infinite: true,
      arrows: false,
      dots: false,
      pauseOnHover: true,
      responsive: [
        {
          breakpoint: 992,
          settings: {
            slidesToShow: 3
          }
        },
        {
          breakpoint: 768,
          settings: {
            slidesToShow: 2
          }
        },
        {
          breakpoint: 480,
          settings: {
            slidesToShow: 1
          }
        }
      ]
    });
  });
$(document).ready(function(){
    $('.ride-slider').slick({
      slidesToShow: 4,
      slidesToScroll: 1,
      autoplay: true,
      autoplaySpeed: 0,            // Speed between auto-scrolls
      speed: 4000,                 // Speed of the scroll itself
      cssEase: 'linear',           // Smooth continuous scrolling
      infinite: true,
      arrows: false,
      dots: false,
      pauseOnHover: true,
      responsive: [
        {
          breakpoint: 992,
          settings: {
            slidesToShow: 3
          }
        },
        {
          breakpoint: 768,
          settings: {
            slidesToShow: 2
          }
        },
        {
          breakpoint: 480,
          settings: {
            slidesToShow: 1
          }
        }
      ]
    });
  });

</script>