@include('includes.header')

  <!-- Hero Section -->
  <section class="brodcrum arm" style="background-image:url({{ url('/') }}/assets/images/contact.jpg);">
  	<div class="container position-relative py-5">
  		<div class="row">
  			<div class="col-lg-9 m-auto py-4">
			    <div class="text-center hero-text">
			      <h1 class="text-white">Contact Us</h1>
			    </div>
  			</div>
  		</div>
  	</div>
  </section>


  <!-- About section -->
  <section class="abs">
  	<div class="container position-relative">
  		<div class="row align-items-center">
  			<div class="col-md-8 col-lg-6 pe-md-5">
  				<div class="about-p cont">
  					<h3>The Tire Studio</h3>
            <h4>Address:</h4>
  					<p class="d-flex gap-2" style="align-items: baseline;"><i class="fas fa-map-marker-alt"></i> 
              16305 117 Avenue NW
              Edmonton, AB T5M 3V3, Canada</p>
              <hr>
              <h4>Phone:</h4>
            <p><i class="fas fa-phone"></i>  (780) 482-1134</p>
            <hr>
            <h4>Business Hours:</h4>
            <p> Monday   :  Friday: 9am - 5pm</p>
            <p> Saturday :  10am - 4pm</p>
            <p> Sunday   :  Closed</p>
  				</div>
  			</div>
  			<div class="col-md-4 col-lg-6">
  				<div class="about-img pe-md-3 pe-lg-4">
  					<img src="images/cantat.jpg" class="img-fluid" alt="about img" />
  				</div>
  			</div>
  		</div>
  	</div>
  </section>

  <section class="contact-section">
    <div class="container">
      <div class="row">
        <!-- Contact Info -->
        <div class="col-md-5 mb-4">
          <div class="contact-form">
            <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2369.439906251619!2d-113.60569792399853!3d53.56776515813418!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x53a02137c32e3cd1%3A0x53491ab579f76cc9!2s16305%20117%20Ave%20NW%2C%20Edmonton%2C%20AB%20T5V%201J5%2C%20Canada!5e0!3m2!1sen!2sin!4v1744298545061!5m2!1sen!2sin" width="100%" height="470" style="border:0;border-radius: 20px !important;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
          </div>
        </div>

        <!-- Contact Form -->
        <div class="col-lg-7">
          <div class="form-sc p-md-5 p-3">
          <div id="msg"></div>
            <form>
              <div class="d-flex gap-4">
                <div class="mb-3 w-100">
                  <input type="text" class="form-control required" placeholder="Your name" id="name" data-name="Name" onkeyup="remove_error_message();">
                </div>

                <div class="mb-3 w-100">
                  <input type="tel" class="form-control required" placeholder="Your phone" id="phone" data-name="Phone" onkeyup="remove_error_message();">
                </div>
              </div>
              <div class="d-flex gap-4">
                <div class="mb-3 w-100">
                  <input type="email" class="form-control required" placeholder="Your email" id="email" data-name="Email" onkeyup="remove_error_message();">
                </div>

                <div class="mb-3 w-100">
                  <input type="text" class="form-control required" placeholder="Subject" id="subject" data-name="Subject" onkeyup="remove_error_message();">
                </div>
              </div>

              <div class="mb-3">
                <textarea class="form-control required" id="message" rows="5" data-name="Message" placeholder="Describe your issue" onkeyup="remove_error_message();" ></textarea>
              </div>
              <div class="d-flex gap-4 justify-space-between">
              <iframe title="reCAPTCHA" width="304" height="78" role="presentation" name="a-m0ug1lmczdqt" frameborder="0" scrolling="no" sandbox="allow-forms allow-popups allow-same-origin allow-scripts allow-top-navigation allow-modals allow-popups-to-escape-sandbox allow-storage-access-by-user-activation" src="https://www.google.com/recaptcha/enterprise/anchor?ar=1&amp;k=6Ld0J8IcAAAAANyrnxzrRlX1xrrdXsOmsepUYosy&amp;co=aHR0cHM6Ly93d3cuYXR3LWRpc3RyaWJ1dG9ycy1jYW5hZGEuY29tOjQ0Mw..&amp;hl=en&amp;v=hbAq-YhJxOnlU-7cpgBoAJHb&amp;theme=light&amp;size=normal&amp;cb=4r7m1pvs8wpr"></iframe>
              <button type="button" class="btns btns-hover" onclick="save_contact_us();"><span>Send Message</span></button>
            </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </section>
  @include('includes.footer')
  <script>
function remove_error_message(){
    var validate = true;
    var html = `<ul style="font-size: 12px;color: #fff;">`;
    $('.required').each(function(){
        if($(this).val() == ''){
            var name = $(this).data('name')
            html += `<li>`+name+` is required. </li>`;
            validate = false;
        }
    });
    html += `</ul>`;
    if(validate == false){
      $("#msg").html(html);
      return false;
    }else{
      $("#msg").html('');
    }
}
  function save_contact_us(){
    var validate = true;
    var html = `<ul style="font-size: 12px;color: red;">`;
    $('.required').each(function(){
        if($(this).val() == ''){
            var name = $(this).data('name')
            html += `<li>`+name+` is required. </li>`;
            validate = false;
        }
    });
    html += `</ul>`;
    if(validate == false)
    {
      $("#msg").html(html);
      return false;
    }else{
      $("#msg").html('');
    }
    $.ajaxSetup({
          headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
      });
      var postdata = {
        "name":$("#name").val(),
        "email":$("#email").val(),
        "phone":$("#phone").val(),
        "subject":$("#subject").val(),
        "message":$("#message").val(),
      }
        $.ajax({
            url: '/save-contact-us',
            type: 'POST',
            data: postdata,
            dataType: 'json',
            success: function (res) {
              $('.required').val('');
              var html = `<p class="text-`+res.color+`">`+res.message+`</p>`;
              $("#msg").html(html);
              setTimeout(function() {
                  $('#msg').html('');
              }, 8000);

            }
        });
  }
  </script>