@include('includes.order_header')
<style>
    .cursor{
        cursor: pointer;
    }
    .table-content table td{
        font-size:15px;
    }
</style>
<!-- Begin Main Content Area -->
<main class="main-content">
    <div class="breadcrumb-area breadcrumb-height" data-bg-image="{{ url('/') }}/order_assets/images/breadcrumb/bg/1-1-1920x400.jpg">
        <div class="container h-100">
            <div class="row h-100">
                <div class="col-lg-12">
                    <div class="breadcrumb-item text-night-rider">
                        <h2 class="breadcrumb-heading">
                            Track Order</h2>
                        <ul>
                            <li>
                                <a href="#">Home /</a>
                            </li>
                            <li>Track Order</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="cart-area mt-5 mb-5">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="table-content table-responsive">
                        <table class="table table-bordered" id="datatable">
                            <thead>
                            <tr>
                                <th>Order No</th>
                                <th>Order Date</th>
                                <th>Total Amount</th>
                                <th>Total Item</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($order_list as $ol)
                            <tr>
                                <td>{{ $ol->order_id }}</td>
                                <td>{{ $ol->order_date }}</td>
                                <td>{{ $ol->total_amount }}</td>
                                <td>{{ $ol->total_item }}</td>
                                <td style="text-transform: capitalize;">{{ $ol->status }}</td>
                                <td><a class="btn btn-danger" onclick="get_order_product('{{ $ol->order_id }}');">View Order</a></td>
                            </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
</main>
<div class="modal" id="productModal">
  <div class="modal-dialog" style="max-width: fit-content;">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h4 class="modal-title">Order Product</h4>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <!-- Modal body -->
      <div class="modal-body">
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive shadow-sm rounded bg-white p-3">
                        <table class="table align-middle table-hover">
                            <thead class="table-light">
                              <tr>
                                <th>#</th>
                                <th>Order Id</th>
                                <th>Product Name</th>
                                <th>Size</th>
                                <th>SKU</th>
                                <th>Qty</th>
                                <th>OSTF</th>
                                <th>Price</th>
                                <th>Total Price</th>
                                <th>Category</th>
                              </tr>
                            </thead>
                            <tbody id="product_list">
                                
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
      </div>

      <!-- Modal footer -->
      <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Close</button>
      </div>

    </div>
  </div>
</div>
<!-- Main Content Area End Here -->
@include('includes.order_footer')

<script>
    
function get_order_product(order_id)
{

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        var postdata = {
          "order_id":order_id
        }
        $.ajax({
              url: '{{ url('/') }}/admin/get-order-product',
              type: 'POST',
              data: postdata,
              dataType: 'json',
              success: function (res) {
                    var html=``;
                    var i=1;
                    $.each(res, function(key,val) {
                        html += `<tr>
                                    <td>`+i+`</td>
                                    <td>`+val.order_id+`</td>
                                    <td>`+val.product_name+`</td>`;
                                    if(val.product_category == 'Tire')
                                    {
                                         html += `<td>`+val.size+`</td>`;
                                    }
                                    else if(val.product_category == 'Wheels')
                                    {
                                        html += `<td>`+val.rim_size+`</td>`;
                                    }
                                    else
                                    {
                                        html += `<td>NA</td>`;
                                    }
                                    html += `<td>`+val.sku+`</td>
                                    <td>`+val.qty+`</td>
                                    <td>`+val.otsf_fee+`</td>
                                    <td>`+val.price+`</td>
                                    <td>`+val.total_price+`</td>
                                    <td>`+val.product_category+`</td>
                                  </tr>`;
                        i++;
                    });
                    $("#product_list").html(html);
                    $("#productModal").modal('show');

              }
        });
}
</script>