@include('includes.header')
  <style>
.product-img {
      max-height: 400px;
      object-fit: cover;
    }
    .star-rating input {
      display: none;
    }
    .star-rating label {
      font-size: 1.5rem;
      color: #f3e10c;
      cursor: pointer;
    }
    .star-rating input:checked ~ label,
    .star-rating label:hover,
    .star-rating label:hover ~ label {
      color: gold;
    }
    .review {
      border-bottom: 1px solid #ddd;
      padding: 1rem 0;
    }
    #reviewForm{
      background: #c1c1c1;
      border-radius: 15px;
      padding: 25px;
    }
    #reviewForm h5{
      font-size: 20px;
      margin-bottom: 20px;
    }
    .dtls h2, .dtls p{
      margin-bottom: 5px;
    }
    #review-list{
      background: #343434;
    padding: 20px;
    border-radius: 14px;
    }
    .review strong{
      color: #fff;
      font-size: 20px;
    }
    .review span{
      font-size: 20px;
    }
    .review p{
      color: #fff;
    }
    .rvwss h4{
      font-size: 28px;
      margin-bottom: 20px;
      color: #fff;
      border-top: 1px solid #bbb;
      padding-top: 20px;
    }
  </style>
  <!-- Hero Section -->
  <section class="brodcrum arm" style="background-image:url({{ url('/') }}/assets/images/nuts-valves-banner.webp);">
    <div class="container position-relative py-5">
      <div class="row">
        <div class="col-lg-9 m-auto py-4">
          <div class="text-center hero-text">
            <h1 class="text-white">Product Details</h1>
          </div>
        </div>
      </div>
    </div>
  </section>
  <section class="wheels-sec accessories">
    <div class="container">
        <div class="row text-white dtls">
            <div class="col-md-4">
              <img src="{{ url('/') }}/{{ $product_detail->image }}" class="img-fluid product-img" alt="Tyre" />
            </div>
            <div class="col-md-8">
              <h2>{{ $product_detail->title }}</h2>
              <p><strong>Price:</strong> ${{ $product_detail->price }}</p>
              <p>{{ $product_detail->description }}</p>

              <!-- Star Rating -->
              <div class="star-rating mb-3">
                @for($i=1; $i<=$product_detail->average_rating; $i++)
                <input type="radio" id="5stars" name="rating" value="5"><label for="5stars">&#9733;</label>
                @endfor
              </div>
            </div>
          </div>

          <!-- Reviews Section -->
          <div class="mt-5 rvwss">
            <h4>Customer Reviews</h4>
            <div id="review-list" class="mb-4">
                @foreach ($review_list as $r)
                <div class="review">
                    <strong>{{ $r->name }}</strong><br><div class="star-rating mb-3">
                    @for ($j=1; $j<= $r->rating;$j++)
                      <label for="5stars">&#9733;</label>
                    @endfor
                    </div>
                    <p>{{ $r->review }}</p></div>
                @endforeach
            </div>

            <!-- Submit Review -->
            @if (session('error'))
                <div class="alert alert-danger alert-dismissible">
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        {{ session('error') }}
                </div>
                @endif
                @if (session('success'))
                <div class="alert alert-success alert-dismissible">
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        {{ session('success') }}
                </div>
            @endif
            <form id="reviewForm" method="post" action="{{ route('save-review') }}">
              @csrf
            <h5>Write a Review</h5>
            <input type="hidden" name="product_id" value="{{ $product_detail->id }}">
            <input type="hidden" name="slug" value="{{ $product_detail->slug }}">
              <div class="mb-3">
                <label for="reviewText" class="form-label">Your Review</label>
                <textarea id="reviewText" class="form-control" rows="3" name="review" required></textarea>
              </div>
              <div class="mb-3">
                <label class="form-label">Rating</label>
                <select id="reviewRating" class="form-select" name="rating" required>
                  <option value="" disabled selected>Choose...</option>
                  <option value="5">★★★★★ (5)</option>
                  <option value="4">★★★★☆ (4)</option>
                  <option value="3">★★★☆☆ (3)</option>
                  <option value="2">★★☆☆☆ (2)</option>
                  <option value="1">★☆☆☆☆ (1)</option>
                </select>
              </div>
              <button type="submit" class="btns btns-hover mt-3 py-2 px-4"><span>Submit Review</span></button>
            </form>
          </div>
        </div>
    </section>
@include('includes.footer')