@include('includes.header')
  <style>
    .filter-sec {
      background: #adaaaa;
    padding: 20px;
    border-radius: 10px;
    }
    .filter-sec h3{
      font-size: 20px;
      text-align: center;
    background: #FEB614;
    margin-bottom: 20px;
    padding: 10px;
    border-radius: 10px;
    color: #ffff;
    }
    .filter-sec input, .filter-sec select{
      padding: 10px;
    color: #000;
    margin-bottom: 10px;
    }
    .filter-sec label{
          color: #000;
    font-size: 19px;
    margin-top: 10px;
    }
    .price-range span{
      font-size: 18px;
      color: #000;
    }
    .product-list .wheels-img{
      padding: 20px 10px;
    }
    .product-list .wheels-img img{
      aspect-ratio: 1.5 / 1;
    object-fit: contain;
    padding: 0 15px;
    }
    .product-list .desc{
      background: #716d6d;
      padding: 20px 10px;
    }
    .product-list .desc h5{
      font-size: 20px;
      margin-bottom: 10px;
    }
    .product-list .desc p{
      margin-bottom: 5px;
    }
  </style>

  <!-- Hero Section -->
  <section class="brodcrum arm" style="background-image:url({{ url('/') }}/assets/images/nuts-valves-banner.webp);">
    <div class="container position-relative py-5">
      <div class="row">
        <div class="col-lg-9 m-auto py-4">
          <div class="text-center hero-text">
            <h1 class="text-white">Product List</h1>
          </div>
        </div>
      </div>
    </div>
  </section>
  <section class="wheels-sec accessories">
    <div class="container">
        <div class="row">
          <div class="col-lg-3">
            <div class="filter-sec">
              <h3>Filter</h3>
              <input type="text" id="searchInput" class="form-control" placeholder="Search by tyre name..." onkeyup="search_by_name(this);" />
              <select id="brandFilter" class="form-select" onchange="search_by_type(this);">
                <option value="">Product type</option>
                <option value="tire">Tyre</option>
                <option value="wheel">Wheels</option>
              </select>
              <label for="priceRange" class="form-label">Price Range</label>
                <input type="range" class="form-range" id="priceRange" min="0" max="300000" step="10" value="300000">
                <div class="price-range d-flex justify-content-between">
                  <span>$0</span><span>$<span id="priceValue">300000</span></span>
                </div>
            </div>
          </div>
          <div class="col-lg-9">
          <div class="row product-list" id="productList">

          </div>
          </div>
        </div>
      </div>
    </section>
@include('includes.footer')
<script>
  const priceRange = document.getElementById("priceRange");
  const priceValue = document.getElementById("priceValue");

      priceRange.addEventListener("input", (e) => {

      priceValue.innerText = `${e.target.value}`;
      var price = $("#priceValue").text();
      var name = $("#searchInput").val();
      var type = $("#brandFilter").val();
      get_product_list(type,name,price);

    });
    get_product_list();

    function search_by_name(e)
    {
        var name = $(e).val();
        var price = $("#priceValue").text();
        var type = $("#brandFilter").val();
        get_product_list(type,name,price);
    }
    function search_by_type(e)
    {
      var type = $(e).val();
      var price = $("#priceValue").text();
      var name = $("#searchInput").val();
      get_product_list(type,name,price);
    }

    function get_product_list(type='',title='',price='')
    {
        $.ajaxSetup({
          headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
        });
        var postdata = {
        "type":type,
        "title":title,
        "price":price,
        }
        $.ajax({
            url: '/get-product-list',
            type: 'POST',
            data: postdata,
            dataType: 'json',
            success: function (res) {
                var html = ``;
                $.each(res.data, function (key, val) {
                    html += `<div class="col-md-4 mb-4 tyre-card">
                        <div class="wheels-img p-0 overflow-hidden rounded">
                            <img src="{{ url('/') }}/`+val.image+`" class="img-fluid" alt="Hub Centering Rings">
                            <div class="desc">
                            <h5 class="card-title">`+val.title+`</h5>
                            <p class="card-text"><strong>Price:</strong> $`+val.price+`</p>
                            <p class="card-text">`+val.description+`</p>
                            <a href="{{ url('/') }}/dealer/product-detail/`+val.slug+`" class="btns btns-hover mt-3 py-2 px-4"><span>View Details</span></a>
                            </div>
                        </div>
                    </div>`;
                });
                $("#productList").html(html);
            }
        });

    }
</script>