<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Homecontroller;
use App\Http\Controllers\Usercontroller as Usercontrollers;
use App\Http\Controllers\admin\Admincontroller;
use App\Http\Controllers\admin\Productcontroller;
use App\Http\Controllers\Ordercontroller;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });

Route::get('/',[Homecontroller::class, 'index']);
Route::get('about-us',[Homecontroller::class, 'about_us']);
Route::get('contact-us',[Homecontroller::class, 'contact_us']);
Route::post('save-contact-us',[Homecontroller::class, 'save_contact_us']);
Route::get('armed-off-road',[Homecontroller::class, 'armed_off_road']);
Route::get('armed-street',[Homecontroller::class, 'armed_street']);
Route::get('armed-syndicate',[Homecontroller::class, 'armed_syndicate']);
Route::get('all-tires',[Homecontroller::class, 'all_tires']);
Route::get('wheel-accessories',[Homecontroller::class, 'wheel_accessories']);
Route::get('track-order',[Homecontroller::class, 'track_order']);
Route::get('return-warranty',[Homecontroller::class, 'warranty_return']);
Route::post('get-warranty-return-form',[Homecontroller::class, 'get_warranty_return_form'])->name('get-warranty-return-form');
Route::post('save-warranty-form',[Homecontroller::class, 'save_warranty_form'])->name('save-warranty-form');
Route::post('save-return-form',[Homecontroller::class, 'save_return_form'])->name('save-return-form');

Route::get('web-order',[Ordercontroller::class, 'web_order']);
Route::get('web-order/search-by-vehicle',[Ordercontroller::class, 'search_by_vehicle']);
Route::get('web-order/search-by-tire',[Ordercontroller::class, 'search_by_tire']);
Route::get('web-order/search-by-wheels',[Ordercontroller::class, 'search_by_wheels']);
Route::get('web-order/search-other',[Ordercontroller::class, 'search_by_other']);
Route::post('web-order/get-all-brand',[Ordercontroller::class, 'get_all_brand'])->name('get-all-brand');
Route::post('web-order/get-all-model',[Ordercontroller::class, 'get_all_model'])->name('get-all-model');
Route::post('web-order/get-all-variant',[Ordercontroller::class, 'get_all_variant'])->name('get-all-variant');
Route::post('web-order/get-variant-detail',[Ordercontroller::class, 'get_variant_detail'])->name('get-variant-detail');
Route::get('web-order/product-search-by-variant/{variant_type}',[Ordercontroller::class, 'product_search_by_variant'])->name('product-search-by-variant');
Route::post('web-order/vehicle-product-search-by-search-key',[Ordercontroller::class, 'vehicle_product_search_by_search_key'])->name('vehicle-product-search-by-search-key');
Route::post('web-order/product-search-by-search-key',[Ordercontroller::class, 'product_search_by_search_key'])->name('product-search-by-search-key');
Route::post('web-order/wheel-product-search-by-search-key',[Ordercontroller::class, 'wheel_product_search_by_search_key'])->name('wheel-product-search-by-search-key');
Route::post('web-order/get-variant-product',[Ordercontroller::class, 'get_variant_product'])->name('get-variant-product');
Route::post('web-order/get-load-index',[Ordercontroller::class, 'get_load_index'])->name('get-load-index');
Route::post('web-order/get-speed-rating',[Ordercontroller::class, 'get_speed_rating'])->name('get-speed-rating');
Route::post('web-order/get-product-type',[Ordercontroller::class, 'get_product_type'])->name('get-product-type');
Route::post('web-order/get-all-diameter',[Ordercontroller::class, 'get_all_diameter'])->name('get-all-diameter');
Route::post('web-order/get-all-rim-width',[Ordercontroller::class, 'get_all_rim_width'])->name('get-all-rim-width');
Route::post('web-order/get-all-offset',[Ordercontroller::class, 'get_all_offset'])->name('get-all-offset');
Route::post('web-order/get-all-overall-diameter',[Ordercontroller::class, 'get_all_overall_diameter'])->name('get-all-overall-diameter');

Route::post('web-order/add-to-cart',[Ordercontroller::class, 'add_to_cart'])->name('add-to-cart');
Route::get('web-order/cart',[Ordercontroller::class, 'cart_list']);
Route::post('web-order/get-cart-list',[Ordercontroller::class, 'get_cart_list'])->name('get-cart-list');
Route::post('web-order/get-cart-count',[Ordercontroller::class, 'get_cart_count'])->name('get-cart-count');
Route::post('web-order/update-cart-qty',[Ordercontroller::class, 'update_cart_qty'])->name('update-cart-qty');
Route::post('web-order/delete-cart-item',[Ordercontroller::class, 'delete_cart_item'])->name('delete-cart-item');
Route::post('web-order/save-order',[Ordercontroller::class, 'save_order'])->name('save-order');
Route::get('web-order/track-order',[Ordercontroller::class, 'track_order']);
Route::post('web-order/get-tire-quick-size',[Ordercontroller::class, 'get_tire_quick_size'])->name('get-tire-quick-size');
Route::post('web-order/get-wheel-quick-size',[Ordercontroller::class, 'get_wheel_quick_size'])->name('get-wheel-quick-size');
Route::post('web-order/get-tire-by-brand',[Ordercontroller::class, 'get_tire_by_brand'])->name('get-tire-by-brand');
Route::post('web-order/get-wheel-by-brand',[Ordercontroller::class, 'get_wheel_by_brand'])->name('get-wheel-by-brand');
Route::post('web-order/search-product-by-size',[Ordercontroller::class, 'search_product_by_size'])->name('search-product-by-size');
Route::post('web-order/search-product-by-brand',[Ordercontroller::class, 'search_product_by_brand'])->name('search-product-by-brand');
Route::post('web-order/search-product-by-wheel-brand',[Ordercontroller::class, 'search_product_by_wheel_brand'])->name('search-product-by-wheel-brand');
Route::post('web-order/search-product-by-wheel-size',[Ordercontroller::class, 'search_product_by_wheel_size'])->name('search-product-by-wheel-size');
Route::post('web-order/get-other-brand',[Ordercontroller::class, 'get_other_brand'])->name('get-other-brand');
Route::post('web-order/search-other-product',[Ordercontroller::class, 'search_other_product'])->name('search-other-product');



Route::get('signin',[Usercontrollers::class, 'signin']);
Route::get('signup',[Usercontrollers::class, 'signup']);
Route::post('save-dealer',[Usercontrollers::class, 'save_dealer'])->name('save-dealer');
Route::get('dealer/product-list',[Usercontrollers::class, 'product_list']);
Route::post('get-product-list',[Usercontrollers::class, 'get_product_list']);
Route::get('dealer/product-detail/{slug}',[Usercontrollers::class, 'product_detail']);
Route::post('save-review',[Usercontrollers::class, 'save_review'])->name('save-review');
Route::post('dealer-login',[Usercontrollers::class, 'login'])->name('dealer-login');
Route::get('dealer-logout',[Usercontrollers::class, 'logout']);



Route::get('admin',[Admincontroller::class, 'index']);
Route::post('admin/login',[Admincontroller::class, 'login'])->name('login');
Route::get('admin/dashboard',[Admincontroller::class, 'dashboard']);
Route::get('admin-logout',[Admincontroller::class, 'logout']);
Route::get('admin/manage-order',[Admincontroller::class, 'manage_order']);
Route::get('admin/manage-dealer',[Admincontroller::class, 'manage_dealer']);
Route::get('admin/edit-dealer/{id}',[Admincontroller::class, 'manage_dealer']);
Route::post('admin-save-dealer',[Admincontroller::class, 'save_dealer'])->name('save-admin-dealer');
Route::post('admin-update-dealer',[Admincontroller::class, 'update_dealer'])->name('update-admin-dealer');
Route::post('admin/delete-dealer',[Admincontroller::class, 'delete_dealer'])->name('delete-dealer');
Route::post('admin/get-order-product',[Admincontroller::class, 'get_order_product'])->name('get-order-product');
Route::get('admin/product-return-request',[Admincontroller::class, 'product_return_request']);
Route::get('admin/product-warranty-request',[Admincontroller::class, 'product_warranty_request']);
Route::post('admin/get-return-product',[Admincontroller::class, 'get_return_product'])->name('get-return-product');


Route::get('admin/manage-inventory',[Productcontroller::class, 'manage_inventory']);
Route::get('admin/edit-product/{id}',[Productcontroller::class, 'manage_inventory']);
Route::get('admin/manage-products',[Productcontroller::class, 'manage_product']);
Route::post('admin/save-product',[Productcontroller::class, 'save_product'])->name('save-product');
Route::post('admin/update-product',[Productcontroller::class, 'update_product'])->name('update-product');
Route::post('admin/delete-product',[Productcontroller::class, 'delete_product'])->name('delete-product');


Route::get('admin/manage-brand',[Productcontroller::class, 'manage_brand']);
Route::get('admin/edit-brand/{id}',[Productcontroller::class, 'manage_brand']);
Route::post('admin/save-brand',[Productcontroller::class, 'save_brand'])->name('save-brand');
Route::post('admin/update-brand',[Productcontroller::class, 'update_brand'])->name('update-brand');
Route::post('admin/delete-brand',[Productcontroller::class, 'delete_brand'])->name('delete-brand');

Route::get('admin/manage-model',[Productcontroller::class, 'manage_model']);
Route::get('admin/edit-model/{id}',[Productcontroller::class, 'manage_model']);
Route::post('admin/save-model',[Productcontroller::class, 'save_model'])->name('save-model');
Route::post('admin/update-model',[Productcontroller::class, 'update_model'])->name('update-model');
Route::post('admin/delete-model',[Productcontroller::class, 'delete_model'])->name('delete-model');

Route::get('admin/manage-product-type',[Productcontroller::class, 'manage_product_type']);
Route::get('admin/edit-product-type/{id}',[Productcontroller::class, 'manage_product_type']);
Route::post('admin/save-product-type',[Productcontroller::class, 'save_product_type'])->name('save-product-type');
Route::post('admin/update-product-type',[Productcontroller::class, 'update_product_type'])->name('update-product-type');
Route::post('admin/delete-product-type',[Productcontroller::class, 'delete_product_type'])->name('delete-product-type');

Route::get('admin/manage-vehicle-type',[Productcontroller::class, 'manage_vehicle_type']);
Route::get('admin/edit-vehicle-type/{id}',[Productcontroller::class, 'manage_vehicle_type']);
Route::post('admin/save-vehicle-type',[Productcontroller::class, 'save_vehicle_type'])->name('save-vehicle-type');
Route::post('admin/update-vehicle-type',[Productcontroller::class, 'update_vehicle_type'])->name('update-vehicle-type');
Route::post('admin/delete-vehicle-type',[Productcontroller::class, 'delete_vehicle_type'])->name('delete-vehicle-type');


Route::get('admin/manage-vehicle-list',[Productcontroller::class, 'manage_vehicle_list']);
Route::get('admin/manage-vehicle-info',[Productcontroller::class, 'manage_vehicle_info']);
Route::get('admin/edit-vehicle-info/{id}',[Productcontroller::class, 'manage_vehicle_info']);
Route::post('admin/save-vehicle-info',[Productcontroller::class, 'save_vehicle_info'])->name('save-vehicle-info');
Route::post('admin/update-vehicle-info',[Productcontroller::class, 'update_vehicle_info'])->name('update-vehicle-info');
Route::post('admin/delete-vehicle-info',[Productcontroller::class, 'delete_vehicle_info'])->name('delete-vehicle-info');


Route::get('admin/manage-rim-width',[Productcontroller::class, 'manage_rim_width']);
Route::get('admin/edit-rim-width/{id}',[Productcontroller::class, 'manage_rim_width']);
Route::post('admin/save-rim-width',[Productcontroller::class, 'save_rim_width'])->name('save-rim-width');
Route::post('admin/update-rim-width',[Productcontroller::class, 'update_rim_width'])->name('update-rim-width');
Route::post('admin/delete-rim-width',[Productcontroller::class, 'delete_rim_width'])->name('delete-rim-width');

Route::get('admin/manage-speed-rating',[Productcontroller::class, 'manage_speed_rating']);
Route::get('admin/edit-speed-rating/{id}',[Productcontroller::class, 'manage_speed_rating']);
Route::post('admin/save-speed-rating',[Productcontroller::class, 'save_speed_rating'])->name('save-speed-rating');
Route::post('admin/update-speed-rating',[Productcontroller::class, 'update_speed_rating'])->name('update-speed-rating');
Route::post('admin/delete-speed-rating',[Productcontroller::class, 'delete_speed_rating'])->name('delete-speed-rating');

Route::get('admin/manage-load-index',[Productcontroller::class, 'manage_load_index']);
Route::get('admin/edit-load-index/{id}',[Productcontroller::class, 'manage_load_index']);
Route::post('admin/save-load-index',[Productcontroller::class, 'save_load_index'])->name('save-load-index');
Route::post('admin/update-load-index',[Productcontroller::class, 'update_load_index'])->name('update-load-index');
Route::post('admin/delete-load-index',[Productcontroller::class, 'delete_load_index'])->name('delete-load-index');

Route::get('admin/manage-diameter',[Productcontroller::class, 'manage_diameter']);
Route::get('admin/edit-diameter/{id}',[Productcontroller::class, 'manage_diameter']);
Route::post('admin/save-diameter',[Productcontroller::class, 'save_diameter'])->name('save-diameter');
Route::post('admin/update-diameter',[Productcontroller::class, 'update_diameter'])->name('update-diameter');
Route::post('admin/delete-diameter',[Productcontroller::class, 'delete_diameter'])->name('delete-diameter');

// Route::get('admin/manage-vehicle-variant',[Productcontroller::class, 'manage_vehicle_variant']);
// Route::get('admin/edit-vehicle-variant/{id}',[Productcontroller::class, 'manage_vehicle_variant']);
// Route::post('admin/save-vehicle-variant',[Productcontroller::class, 'save_vehicle_variant'])->name('save-vehicle-variant');
// Route::post('admin/update-vehicle-variant',[Productcontroller::class, 'update_vehicle_variant'])->name('update-vehicle-variant');
// Route::post('admin/delete-vehicle-variant',[Productcontroller::class, 'delete_vehicle_variant'])->name('delete-vehicle-variant');

Route::post('admin/get-model-by-brand',[Productcontroller::class, 'get_model_by_brand'])->name('get-model-by-brand');
Route::post('admin/get-vehicle-variant',[Productcontroller::class, 'get_vehicle_variant'])->name('get-vehicle-variant');
Route::post('admin/delete-product-image',[Productcontroller::class, 'delete_product_image'])->name('delete-product-image');


Route::get('404.php',[Homecontroller::class, 'errorpage']);

