<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
	<title>The Tire Studio</title>
	<link href="https://fonts.googleapis.com/css2?family=Bree+Serif&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Slick CSS -->
  <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css"/>
  <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick-theme.css"/>
  <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/style.css')); ?>">
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
</head>
<body>

  <!-- Navbar -->
  <header>
  	<div class="container">
  		<div class="row">
  			<div class="col-md-12">
			  <nav class="navbar navbar-expand-lg p-0">
			    <div class="container">
			      <a class="navbar-brand" href="#"><img src="<?php echo e(url('/')); ?>/assets/images/logo.png" class="img-fluid" alt="The Tire Studio Logo"/></a>
			      <button class="navbar-toggler" data-bs-toggle="collapse" data-bs-target="#navbarNav">
			        <span class="navbar-toggler-icon"></span>
			      </button>
				  <div id="navbarNav" class="collapse navbar-collapse">
					<ul class="navbar-nav ms-auto">
						<li class="nav-item"><a class="nav-link" href="<?php echo e(url('/')); ?>">Home</a></li>
						<li class="nav-item dropdown">
						<a class="nav-link dropdown-toggle" href="#" id="dealerDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
						Wheels
						</a>
						<ul class="dropdown-menu" aria-labelledby="dealerDropdown">
							<li><a class="dropdown-item nav-link text-black" href="<?php echo e(url('/')); ?>/armed-off-road">Armed Off-Road</a></li>
							<li><a class="dropdown-item nav-link text-black" href="<?php echo e(url('/')); ?>/armed-street">Armed Street</a></li>
							<li><a class="dropdown-item nav-link text-black" href="<?php echo e(url('/')); ?>/armed-syndicate">Armed Syndicate</a></li>
						</ul>
						</li>
						<li class="nav-item"><a class="nav-link" href="<?php echo e(url('/')); ?>/all-tires">Tires</a></li>
						<li class="nav-item"><a class="nav-link" href="<?php echo e(url('/')); ?>/wheel-accessories">Accessories</a></li>
						<li class="nav-item dropdown">
						<a class="nav-link dropdown-toggle" href="#" id="dealerDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
							Dealer
						</a>
						<ul class="dropdown-menu" aria-labelledby="dealerDropdown">
							<?php if(Session::get('user_data')): ?>
							<li><a class="dropdown-item nav-link text-black" href="<?php echo e(url('/')); ?>/web-order">Products</a></li>
							<li><a class="dropdown-item nav-link text-black" href="<?php echo e(url('/')); ?>/web-order/track-order">Track Order</a></li>
							<li><a class="dropdown-item nav-link text-black" href="<?php echo e(url('/')); ?>/dealer-logout">Logout</a></li>
							<?php else: ?>
							<li><a class="dropdown-item nav-link text-black" href="<?php echo e(url('/')); ?>/signin">Dealer Portal</a></li>
							<li><a class="dropdown-item nav-link text-black" href="<?php echo e(url('/')); ?>/signup">Become a Dealer</a></li>
							<?php endif; ?>
						</ul>
						</li>
						<li class="nav-item"><a class="nav-link" href="<?php echo e(url('/')); ?>/contact-us">Contact Us</a></li>
					</ul>
					</div>
			    </div>
			  </nav>
  			</div>
  		</div>
  	</div>
  </header>
<?php /**PATH /home/ecommerceseo/public_html/thetireshop/resources/views/includes/header.blade.php ENDPATH**/ ?>