<?php echo $__env->make('includes.admin_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="d-flex" id="wrapper">
  <!-- Sidebar -->
  <?php echo $__env->make('includes.admin_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <!-- Page Content -->

    <!-- Main Content -->
    <div class="container-fluid px-4 py-4">
      <!-- Dashboard Cards -->
      <div class="row g-4 overr">
        <div class="col-md-3">
          <div class="card ttle-wheels shadow-sm">
            <div class="card-body">
              <h6><i class="bi bi-circle me-2"></i>Total Wheels</h6>
              <h4 class="fw-bold"><?php echo e($wheel_count); ?></h4>
            </div>
          </div>
        </div>
        <div class="col-md-3">
          <div class="card ttle-tire shadow-sm">
            <div class="card-body">
              <h6><i class="bi bi-record-circle me-2"></i>Total Tires</h6>
              <h4 class="fw-bold"><?php echo e($tire_count); ?></h4>
            </div>
          </div>
        </div>
        <div class="col-md-3">
          <div class="card nw-order shadow-sm">
            <div class="card-body">
              <h6><i class="bi bi-cart-check-fill me-2"></i>New Orders</h6>
              <h4 class="fw-bold"><?php echo e($new_order); ?></h4>
            </div>
          </div>
        </div>
        <div class="col-md-3">
          <div class="card lw-stock shadow-sm">
            <div class="card-body">
              <h6><i class="bi bi-exclamation-triangle-fill me-2"></i>Low Stock</h6>
              <h4 class="fw-bold"><?php echo e($low_stock); ?> Items</h4>
            </div>
          </div>
        </div>
      </div>
      <hr />
      <!-- Overview Stats -->
      <div class="row mt-3">
        <div class="col-md-6">
          <div class="card tp-prd shadow-sm">
            <div class="card-header text-white">
              <i class="bi bi-box"></i> Top Products
            </div>
            <ul class="list-group list-group-flush">
                <?php $__currentLoopData = $top_product; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <li class="list-group-item d-flex justify-content-between">
                    <span title="<?php echo e($tp->product_name); ?>"><?php echo e(character_limit($tp->product_name,50)); ?></span> <span class="badge bg-success"><?php echo e($tp->total_qty); ?> sold</span>
                  </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
          </div>
        </div>
        <div class="col-md-6">
          <div class="card tp-prd shadow-sm">
            <div class="card-header text-white">
              <i class="bi bi-clock-history"></i> Recent Orders
            </div>
            <ul class="list-group lsttt list-group-flush">
            <?php $__currentLoopData = $recent_order; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <li class="list-group-item">Order #<?php echo e($rp->order_id); ?> - <?php echo e($rp->qty); ?>x <?php echo e($rp->product_category); ?> - <span class="text-success"><?php echo e($rp->status); ?></span></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
          </div>
        </div>

        <!-- Product Table -->
        <div class="card btdt mt-3">
          <div class="card-header text-white">
              <div class="row">
                  <div class="col-md-6">Product Management</div>
                  <div class="col-md-6" style="text-align:right;"><a href="<?php echo e(url('admin/manage-inventory')); ?>" style="color:red;font-weight:bold;">View All</a></div>
              </div>
          </div>
          <div class="card-body p-0">
            <table class="table align-middle table-bordered invt">
        <thead class="table-light">
          <tr>
            <th>#</th>
            <th>Description</th>
            <th>Size</th>
            <th>Product Type</th>
            <th>Category</th>
            <th>Stock</th>
            <th>Main Price</th>
            <th>Offer Price</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $productdata; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
        <td><?php echo e($key + 1); ?></td>
        <td><span data-toggle="tooltip" data-placement="top" title="<?php echo e($p->title); ?>"><?php echo e(character_limit($p->title,30)); ?></span></td>
        <?php if($p->category == 'Tire'): ?>
        <td><?php echo e($p->size); ?></td>
        <?php elseif($p->category == 'Wheels'): ?>
        <td><?php echo e($p->rim_size); ?></td>
        <?php else: ?>
        <td>NA</td>
        <?php endif; ?>
        <td><?php echo e($p->product_type); ?></td>
        <td><span class="badge <?php if($p->category == 'Tire'): ?> bg-primary <?php elseif($p->category == 'Wheels'): ?> bg-warning <?php else: ?> bg-info <?php endif; ?>"><i
            class="bi bi-circle-fill me-1"></i><?php echo e($p->category); ?></span></td>
        <td><?php echo e($p->stock_qty); ?></td>
        <td><?php echo e($p->main_price); ?></td>
        <td><?php echo e($p->offer_price); ?></td>
        <td>
          <a href="<?php echo e(url('/')); ?>/admin/edit-product/<?php echo e($p->id); ?>" class="btn btn-sm btn-outline-info"><i
            class="bi bi-pencil"></i></a>
          <button class="btn btn-sm btn-outline-danger" onclick="confirmDelete(<?php echo e($p->id); ?>)"><i
            class="bi bi-trash"></i></button>
        </td>
        </tr>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>
<?php echo $__env->make('includes.admin_footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script>
  function confirmDelete(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "This action cannot be undone.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {

              $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                var postdata = {
                  "id":id
                }
                  $.ajax({
                      url: '<?php echo e(url('/')); ?>/admin/delete-product',
                      type: 'POST',
                      data: postdata,
                      dataType: 'json',
                      success: function (res) {
                        if(res.status == false)
                        {
                            Swal.fire({
                                title: 'Error!',
                                text: 'Something went wrong',
                                icon: 'warning',
                                confirmButtonText: 'OK'
                            });
                        }
                        else
                        {
                            Swal.fire({
                                title: 'Success!',
                                text: 'Data deleted successfully.',
                                icon: 'success',
                                confirmButtonText: 'OK'
                                }).then((result) => {
                                if (result.isConfirmed) {
                                    location.reload();
                                }
                            });
                        }

                      }
                  });
                
            }
        });
    }
</script>
<?php /**PATH /home/ecommerceseo/public_html/thetireshop/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>