<?php echo $__env->make('includes.admin_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="d-flex" id="wrapper">
  <!-- Sidebar -->
  <?php echo $__env->make('includes.admin_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Main Content -->

    <div class="container-fluid px-4 py-4">
    <h2 class="mb-4"><i class="bi bi-box2-fill me-2"></i>Model Dashboard</h2>

    <!-- Add Inventory Form -->
    <div class="form-container mb-5">
    <?php if(session('error')): ?>
    <div class="alert alert-danger alert-dismissible">
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            <?php echo e(session('error')); ?>

        </div>
    <?php endif; ?>
    <?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible">
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            <?php echo e(session('success')); ?>

        </div>
  <?php endif; ?>
      <h5 class="mb-3">Add New Vehicle Variant</h5>
      <?php if(Request::segment(3)): ?>
      <form action="<?php echo e(route('update-vehicle-variant')); ?>" method="post" enctype="multipart/form-data">
      <input type="hidden" name="id" value="<?php echo e($vehicle_variant_detail->id); ?>">
      <?php else: ?>
      <form action="<?php echo e(route('save-vehicle-variant')); ?>" method="post" enctype="multipart/form-data">
        <?php endif; ?>
      <?php echo csrf_field(); ?>
        <div class="row g-3">

        <div class="col-md-4">
            <label class="form-label">Year</label>
            <div class="input-group">
              <span class="input-group-text"><i class="bi bi-archive"></i></span>
              <select class="form-select" name="year" required>
                <option value="" selected disabled>Select Year</option>
                <?php for($i=date('Y'); $i >= date('Y')-70;$i--): ?>
                  <option value="<?php echo e($i); ?>" <?php if(Request::segment(3) && $vehicle_variant_detail->year == $i): ?> selected  <?php endif; ?>><?php echo e($i); ?></option>
                <?php endfor; ?>
              </select>
            </div>
        </div>

        <div class="col-md-4">
            <label class="form-label">Brand</label>
            <div class="input-group">
              <span class="input-group-text"><i class="bi bi-archive"></i></span>
              <select class="form-select" name="brand" required onchange="getModel(this.value);">
                <option value="" selected disabled>Select Brand</option>
                <?php $__currentLoopData = $brand_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($bc->id); ?>" <?php if(Request::segment(3) && $vehicle_variant_detail->brand == $bc->id): ?> selected  <?php endif; ?>><?php echo e($bc->brand_name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>
        </div>
        <div class="col-md-4">
            <label class="form-label">Model</label>
            <div class="input-group">
              <span class="input-group-text"><i class="bi bi-archive"></i></span>
              <select class="form-select" name="model" id="product_model" required>
                <option value="" selected disabled>Select model</option>
              </select>
            </div>
        </div>

        <div class="col-md-4">
            <label class="form-label">Vehicle Type</label>
            <div class="input-group">
              <span class="input-group-text"><i class="bi bi-archive"></i></span>
              <select class="form-select" name="type" required>
                <option value="" selected disabled>Select Vehicle Type</option>
                <?php $__currentLoopData = $vehicle_type; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($vt->id); ?>" <?php if(Request::segment(3) && $vehicle_variant_detail->brand == $vt->id): ?> selected  <?php endif; ?>><?php echo e($vt->vehicle_type); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>
        </div>

        <div class="col-md-4 tire_content">    
            <label class="form-label">Variant Name</label>
            <div class="input-group">
              <span class="input-group-text"><i class="bi bi-archive"></i></span>
              <input type="text" class="form-control" name="variant" placeholder="e.g. X-Zeta" value="<?php if(Request::segment(3)): ?><?php echo e($vehicle_variant_detail->variant); ?><?php endif; ?>" required>
            </div>
        </div>

        <div class="col-md-6">
          <label class="form-label">Status</label>
          <div class="input-group">
            <span class="input-group-text"><i class="bi bi-archive"></i></span>
            <select class="form-select" name="status" required>
              <option value="" selected disabled>Select status</option>
              <option value="active" <?php if(Request::segment(3) && $vehicle_variant_detail->status == 'active'): ?> selected  <?php endif; ?>>Active</option>
              <option value="inactive" <?php if(Request::segment(3) && $vehicle_variant_detail->status == 'inactive'): ?> selected  <?php endif; ?>>Inactive</option>
            </select>
          </div>
        </div>


          <div class="col-12 text-end">
          <?php if(Request::segment(3)): ?>
          <button type="submit" class="btns btns-hover"><span><i class="bi bi-save me-1"></i> Update Vehicle Variant</span></button>
          <?php else: ?>
            <button type="submit" class="btns btns-hover"><span><i class="bi bi-save me-1"></i> Save Vehicle Variant</span></button>
          <?php endif; ?>
          </div>
        </div>
      </form>
    </div>

    <!-- Inventory Table -->
    <div class="table-responsive bg-white p-4 rounded shadow-sm">
      <h5 class="mb-3">Current Variant</h5>
      <table class="table align-middle table-bordered invt">
        <thead class="table-light">
          <tr>
            <th>#</th>
            <th>Variant</th>
            <th>Year</th>
            <th>Type</th>
            <th>Brand</th>
            <th>Model</th>
            <th>Status</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
           <?php $__currentLoopData = $variantdata; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
            <td><?php echo e($key+1); ?></td>
            <td><?php echo e($p->year); ?></td>
            <td><?php echo e($p->variant); ?></td>
            <td><?php echo e($p->vehicle_type); ?></td>
            <td><?php echo e($p->brand_name); ?></td>
            <td><?php echo e($p->model_name); ?></td>
            <td>
                <span class="badge <?php if($p->status == 'active'): ?> bg-primary <?php else: ?> bg-warning <?php endif; ?>"><i class="bi bi-circle-fill me-1"></i><?php echo e($p->status); ?></span>
            </td>
            <td>
              <a href="<?php echo e(url('/')); ?>/admin/edit-vehicle-variant/<?php echo e($p->id); ?>" class="btn btn-sm btn-outline-info"><i class="bi bi-pencil"></i></a>
              <button class="btn btn-sm btn-outline-danger" onclick="confirmDelete(<?php echo e($p->id); ?>)"><i class="bi bi-trash"></i></button>
            </td>
          </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
    </div>
  </div>

</div>
</div>
<?php echo $__env->make('includes.admin_footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script>
<?php if(Request::segment(3)): ?>
    var model = <?php echo e($vehicle_variant_detail->model); ?>;
    getModel(<?php echo e($vehicle_variant_detail->brand); ?>);
<?php else: ?>
    var model = '';
<?php endif; ?>
  $('#productImageInput').on('change', function(event) {
    const file = event.target.files[0];
    if (file) {
        const reader = new FileReader();

        reader.onload = function(e) {
            $('#imagePreview').attr('src', e.target.result).show();
        };

        reader.readAsDataURL(file);
    }
});

function getModel(brand_id) 
{

    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    var postdata = {
      "brand_id":brand_id
    }
    $.ajax({
        url: '<?php echo e(url('/')); ?>/admin/get-model-by-brand',
        type: 'POST',
        data: postdata,
        dataType: 'json',
        success: function (res) {
          if(res.status == true)
          {
              var html = `<option value="">Select Model</option>`;
              $.each(res.data, function (key, val) {
                if(val.id == model)
                {
                    var selected = 'selected';
                }
                else
                {
                    var selected = '';
                }
                html += `<option value="`+val.id+`" `+selected+`>`+val.model_name+`</option>`;
              });
              $("#product_model").html(html);
          }
          else
          {
                Swal.fire({
                  title: 'Error!',
                  text: res.msg,
                  icon: 'error',
                  confirmButtonText: 'OK'
              });
          }

        }
    });
}

function confirmDelete(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "This action cannot be undone.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {

              $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                var postdata = {
                  "id":id
                }
                  $.ajax({
                      url: '<?php echo e(url('/')); ?>/admin/delete-vehicle-variant',
                      type: 'POST',
                      data: postdata,
                      dataType: 'json',
                      success: function (res) {
                        if(res.status == false)
                        {
                            Swal.fire({
                                title: 'Error!',
                                text: 'Something went wrong',
                                icon: 'warning',
                                confirmButtonText: 'OK'
                            });
                        }
                        else
                        {
                            Swal.fire({
                                title: 'Success!',
                                text: 'Data deleted successfully.',
                                icon: 'success',
                                confirmButtonText: 'OK'
                                }).then((result) => {
                                if (result.isConfirmed) {
                                  location.href = '<?php echo e(url('/')); ?>/admin/manage-vehicle-variant';
                                }
                            });
                        }

                      }
                  });
                
            }
        });
    }

</script><?php /**PATH C:\xampp\htdocs\thetireshop\resources\views/admin/vehicle_variant.blade.php ENDPATH**/ ?>