<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>W&T Admin Login</title>

  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
  <!-- Bootstrap Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet" />
  <!-- Custom CSS -->
  <link rel="stylesheet" href="<?php echo e(asset('admin_assets/css/style.css')); ?>" />
  <style>
    body {
  background-image: url('<?php echo e(url('/')); ?>/admin_assets/images/bg-img.webp');
  background-size: cover;
  background-repeat: no-repeat;
  background-position: center;
  backdrop-filter: blur(4px);
}

.card {
  backdrop-filter: blur(10px);
  background-color: rgb(152 150 150 / 85%);
  border: none;
  border-radius: 1rem;
  color: #fff;
}

  </style>
</head>
<body class="bg-light d-flex align-items-center justify-content-center vh-100">

  <div class="card shadow-lg p-5" style="max-width: 400px; width: 100%;">
  <?php if(session('error')): ?>
    <div class="alert alert-danger alert-dismissible">
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            <?php echo e(session('error')); ?>

        </div>
    <?php endif; ?>
    <?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible">
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            <?php echo e(session('success')); ?>

        </div>
  <?php endif; ?>
    <div class="text-center mb-2">
      <i class="bi bi-gear-fill fs-1 "></i>
      <h4 class="mt-2">W&T Admin</h4>
      <p class="">Login to your dashboard</p>
    </div>
    <hr>
    <form action="<?php echo e(route('login')); ?>" method="post">
      <?php echo csrf_field(); ?>
      <div class="mb-3">
        <label for="email" class="form-label">Email address</label>
        <div class="input-group">
          <span class="input-group-text"><i class="bi bi-person"></i></span>
          <input type="email" class="form-control" id="email" name="email" placeholder="admin@example.com" required />
        </div>
      </div>
      <div class="mb-3">
        <label for="password" class="form-label">Password</label>
        <div class="input-group">
          <span class="input-group-text"><i class="bi bi-lock"></i></span>
          <input type="password" class="form-control" id="password" name="password" placeholder="••••••••" required />
        </div>
      </div>
      <div class="d-flex justify-content-between align-items-center mb-3">
        <!-- <div class="form-check">
          <input type="checkbox" class="form-check-input" id="remember" />
          <label class="form-check-label" for="remember">Remember me</label>
        </div> -->
        <!-- <a href="#" class="text-decoration-none text-white">Forgot Password?</a> -->
      </div>
      <button type="submit" class="btns btns-hover w-100">Login</button>
    </form>
    <div class="text-center mt-4">
      <small class="">© 2025 Wheels & Tires Admin</small>
    </div>
  </div>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\thetireshop\resources\views/admin/login.blade.php ENDPATH**/ ?>