<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Wheels & Tires User Login</title>

  <!-- Bootstrap 5 -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
  <!-- Bootstrap Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet" />
  <!-- Custom CSS -->
  <link rel="stylesheet" href="<?php echo e(asset('admin_assets/css/style.css')); ?>" />
  <style>
    body {
  background-image: url('<?php echo e(url('/')); ?>/admin_assets/images/bg-img.webp');
  background-size: cover;
  background-repeat: no-repeat;
  background-position: center;
  backdrop-filter: blur(4px);
}

.card {
  backdrop-filter: blur(10px);
  background-color: rgb(152 150 150 / 85%);
  border: none;
  border-radius: 1rem;
  color: #fff;
}

  </style>
</head>
<body class="bg-light d-flex justify-content-center align-items-center vh-100">

  <div class="card shadow-lg p-5" style="max-width: 400px; width: 100%;">
    <div class="text-center mb-2">
      <i class="bi bi-gear-fill fs-1"></i>
      <h4 class="mt-2">Wheels & Tires Dealer Login</h4>
      <p class="">Enter your credentials to access your account</p>
    </div>
    <hr>
    <form action="<?php echo e(route('dealer-login')); ?>" method="POST">
      <?php echo csrf_field(); ?>
      <!-- Email Input -->
      <div class="mb-3">
        <label for="email" class="form-label">Email Address</label>
        <div class="input-group">
          <span class="input-group-text"><i class="bi bi-person"></i></span>
          <input type="email" class="form-control" id="email" name="email" placeholder="user@example.com" required />
        </div>
      </div>

      <!-- Password Input -->
      <div class="mb-3">
        <label for="password" class="form-label">Password</label>
        <div class="input-group">
          <span class="input-group-text"><i class="bi bi-lock"></i></span>
          <input type="password" class="form-control" id="password" name="password" placeholder="••••••••" required />
        </div>
      </div>

      <!-- Remember Me and Forgot Password -->
      <div class="d-flex justify-content-between align-items-center mb-3">
        <!-- <div class="form-check">
          <input type="checkbox" class="form-check-input" id="remember" />
          <label class="form-check-label" for="remember">Remember me</label>
        </div>
        <a href="#" class="text-decoration-none">Forgot Password?</a> -->
      </div>

      <!-- Login Button -->
      <button type="submit" class="btns btns-hover w-100">Login</button>
    </form>

    <!-- Footer -->
    <div class="text-center mt-4">
      <p class="">Don't have an account? <a href="<?php echo e(url('/signup')); ?>">Sign up here</a></p>
      <small class="">© 2025 Wheels & Tires</small>
    </div>
  </div>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\tireshop\resources\views/admin/userlogin.blade.php ENDPATH**/ ?>