<?php echo $__env->make('includes.admin_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="d-flex" id="wrapper">
  <!-- Sidebar -->
  <?php echo $__env->make('includes.admin_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Main Content -->

    <div class="container-fluid px-4 py-4">
    <h2 class="mb-4"><i class="bi bi-box2-fill me-2"></i>Diameter Dashboard</h2>

    <!-- Add Inventory Form -->
    <div class="form-container mb-5">
    <?php if(session('error')): ?>
    <div class="alert alert-danger alert-dismissible">
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            <?php echo e(session('error')); ?>

        </div>
    <?php endif; ?>
    <?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible">
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            <?php echo e(session('success')); ?>

        </div>
  <?php endif; ?>
      <h5 class="mb-3">Add New Diameter</h5>
      <?php if(Request::segment(3)): ?>
      <form action="<?php echo e(route('update-diameter')); ?>" method="post" enctype="multipart/form-data">
      <input type="hidden" name="id" value="<?php echo e($diameter_detail->id); ?>">
      <?php else: ?>
      <form action="<?php echo e(route('save-diameter')); ?>" method="post" enctype="multipart/form-data">
        <?php endif; ?>
      <?php echo csrf_field(); ?>
        <div class="row g-3">
          <!-- Product Name -->
          <div class="col-md-6">
            <label class="form-label">Diameter</label>
            <div class="input-group">
              <span class="input-group-text"><i class="bi bi-card-text"></i></span>
              <input type="text" class="form-control" name="diameter" placeholder="e.g. 123" value="<?php if(Request::segment(3)): ?> <?php echo e($diameter_detail->diameter); ?>  <?php endif; ?>" required>
            </div>
          </div>

          <div class="col-12 text-end">
          <?php if(Request::segment(3)): ?>
          <button type="submit" class="btns btns-hover"><span><i class="bi bi-save me-1"></i> Update Diameter</span></button>
          <?php else: ?>
            <button type="submit" class="btns btns-hover"><span><i class="bi bi-save me-1"></i> Save Diameter</span></button>
          <?php endif; ?>
          </div>
        </div>
      </form>
    </div>

    <!-- Inventory Table -->
    <div class="table-responsive bg-white p-4 rounded shadow-sm">
      <h5 class="mb-3">Current Diameter</h5>
      <table class="table align-middle table-bordered invt">
        <thead class="table-light">
          <tr>
            <th>#</th>
            <th>Diameter</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
           <?php $__currentLoopData = $diameterdata; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
            <td><?php echo e($key+1); ?></td>
            <td><?php echo e($p->diameter); ?></td>
            <td>
              <a href="<?php echo e(url('/')); ?>/admin/edit-diameter/<?php echo e($p->id); ?>" class="btn btn-sm btn-outline-info"><i class="bi bi-pencil"></i></a>
              <button class="btn btn-sm btn-outline-danger" onclick="confirmDelete(<?php echo e($p->id); ?>)"><i class="bi bi-trash"></i></button>
            </td>
          </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
    </div>
  </div>

</div>
</div>
<?php echo $__env->make('includes.admin_footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script>
function confirmDelete(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "This action cannot be undone.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {

              $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                var postdata = {
                  "id":id
                }
                  $.ajax({
                      url: '<?php echo e(url('/')); ?>/admin/delete-diameter',
                      type: 'POST',
                      data: postdata,
                      dataType: 'json',
                      success: function (res) {
                        if(res.status == false)
                        {
                            Swal.fire({
                                title: 'Error!',
                                text: 'Something went wrong',
                                icon: 'warning',
                                confirmButtonText: 'OK'
                            });
                        }
                        else
                        {
                            Swal.fire({
                                title: 'Success!',
                                text: 'Data deleted successfully.',
                                icon: 'success',
                                confirmButtonText: 'OK'
                                }).then((result) => {
                                if (result.isConfirmed) {
                                  location.href = '<?php echo e(url('/')); ?>/admin/manage-diameter';
                                }
                            });
                        }

                      }
                  });
                
            }
        });
    }

</script><?php /**PATH C:\xampp\htdocs\thetireshop\resources\views/admin/diameter.blade.php ENDPATH**/ ?>