<?php echo $__env->make('includes.admin_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<style>
  .required {
    color: red;
    font-weight: bold;
  }
</style>
<div class="d-flex" id="wrapper">
  <?php echo $__env->make('includes.admin_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <div class="container-fluid px-4 py-4">
    <h2 class="mb-4"><i class="bi bi-box2-fill me-2"></i>Vehicle Dashboard</h2>

    <div class="form-container mb-5">
      <?php if(session('error')): ?>
      <div class="alert alert-danger alert-dismissible">
      <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
      <?php echo e(session('error')); ?>

      </div>
    <?php endif; ?>
      <?php if(session('success')): ?>
      <div class="alert alert-success alert-dismissible">
      <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
      <?php echo e(session('success')); ?>

      </div>
    <?php endif; ?>
      <h5 class="mb-3">Add New Vehicle Item</h5>
      <?php if(Request::segment(3)): ?>
      <form action="<?php echo e(route('update-vehicle-info')); ?>" method="post" enctype="multipart/form-data">
      <input type="hidden" name="id" value="<?php echo e($vehicle_info_detail->id); ?>">
  <?php else: ?>
      <form action="<?php echo e(route('save-vehicle-info')); ?>" method="post" enctype="multipart/form-data">
      <?php endif; ?>
          <?php echo csrf_field(); ?>
          <div class="row g-3">
            <div class="col-md-4">
              <label class="form-label">Year <span class="required">*</span></label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <select class="form-select" name="year" id="year" required>
                  <option value="" selected disabled>Select Year</option>
                  <?php for($i = date('Y'); $i >= date('Y') - 70; $i--): ?>
            <option value="<?php echo e($i); ?>" <?php if(Request::segment(3) && $vehicle_info_detail->year == $i): ?> selected <?php endif; ?>>
            <?php echo e($i); ?></option>
          <?php endfor; ?>
                </select>
              </div>
            </div>
            <div class="col-md-4">
              <label class="form-label">Brand <span class="required">*</span></label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <select class="form-select" name="brand" id="brand" required onchange="getModel(this.value);">
                  <option value="" selected disabled>Select Brand</option>
                  <?php $__currentLoopData = $brand_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($bc->id); ?>" <?php if(Request::segment(3) && $vehicle_info_detail->brand == $bc->id): ?> selected
          <?php endif; ?>><?php echo e($bc->brand_name); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>
            </div>
            <div class="col-md-4">
              <label class="form-label">Model <span class="required">*</span></label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <select class="form-select" name="model" id="product_model" required>
                  <option value="" selected disabled>Select model</option>
                </select>
              </div>
            </div>
            <div class="col-md-4">
              <label class="form-label">Vehicle type <span class="required">*</span></label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <select class="form-select" name="vehicle_type" id="vehicle_type" required
                  onchange="get_vehicle_variant();">
                  <option value="" selected disabled>Select Vehicle type</option>
                  <?php $__currentLoopData = $vehicle_type_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($vt->id); ?>" <?php if(Request::segment(3) && $vehicle_info_detail->vehicle_type == $vt->id): ?>
          selected <?php endif; ?>><?php echo e($vt->vehicle_type); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>
            </div>
          <div class="col-md-4 tire_content">    
              <label class="form-label">Variant Name</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <input type="text" class="form-control" name="vehicle_variant" placeholder="e.g. X-Zeta" value="<?php if(Request::segment(3)): ?><?php echo e($vehicle_info_detail->vehicle_variant); ?><?php endif; ?>" required>
              </div>
          </div>


            <div class="col-md-4">
              <label class="form-label">Product Status <span class="required">*</span></label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <select class="form-select" name="status" required>
                  <option value="" selected disabled>Select status</option>
                  <option value="active" <?php if(Request::segment(3) && $vehicle_info_detail->status == 'active'): ?> selected <?php endif; ?>>
                    Active</option>
                  <option value="inactive" <?php if(Request::segment(3) && $vehicle_info_detail->status == 'inactive'): ?> selected
        <?php endif; ?>>Inactive</option>
                </select>
              </div>
            </div>

            <div class="col-md-4">
              <label class="form-label">Rim Width</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <select class="form-select" name="rim_width_range">
                  <option value="" selected disabled>Select Rim Width</option>
                  <?php $__currentLoopData = $rim_width_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($rw->id); ?>" <?php if(Request::segment(3) && $vehicle_info_detail->rim_width_range == $rw->id): ?>
          selected <?php endif; ?>><?php echo e($rw->rim_width_minimum . "x" . $rw->rim_width_maximum . "J"); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>
            </div>

            <div class="col-md-4 tire_content">
              <label class="form-label">Tire Size</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <input type="text" class="form-control" name="tire_size" placeholder="e.g. 235/40ZR19"
                  value="<?php if(Request::segment(3)): ?><?php echo e($vehicle_info_detail->size); ?><?php endif; ?>">
              </div>
            </div>

            <div class="col-md-4 wheel_content">
              <label class="form-label">Rim Size</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <input type="text" class="form-control" name="rim_size" placeholder="e.g. 19x8.5j"
                  value="<?php if(Request::segment(3)): ?><?php echo e($vehicle_info_detail->rim_size); ?><?php endif; ?>">
              </div>
            </div>

            <div class="col-md-4 wheel_content">
              <label class="form-label">Bolt Circle</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <input type="text" class="form-control" name="bolt_circle" placeholder="e.g. 5-114.3mm"
                  value="<?php if(Request::segment(3)): ?><?php echo e($vehicle_info_detail->bolt_circle); ?><?php endif; ?>">
              </div>
            </div>
            <div class="col-md-4 tire_content">
              <label class="form-label">Load Speed</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <input type="text" class="form-control" name="load_speed" placeholder="e.g. 96V"
                  value="<?php if(Request::segment(3)): ?><?php echo e($vehicle_info_detail->load_speed); ?><?php endif; ?>">
              </div>
            </div>
            <div class="col-md-4 wheel_content">
              <label class="form-label">Offset Distance</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <input type="text" class="form-control" name="offset_distance" placeholder="e.g. 129.99"
                  value="<?php if(Request::segment(3)): ?><?php echo e($vehicle_info_detail->offset_distance); ?><?php endif; ?>">
              </div>
            </div>

            <div class="col-md-4 tire_content">
              <label class="form-label">OD Value</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <input type="text" class="form-control" name="od_value" placeholder="e.g. 29.99"
                  value="<?php if(Request::segment(3)): ?><?php echo e($vehicle_info_detail->od_value); ?><?php endif; ?>">
              </div>
            </div>
            <div class="col-md-4 tire_content">
              <label class="form-label">Inflation Front</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <input type="text" class="form-control" name="inflation_front" placeholder="e.g. 38psi"
                  value="<?php if(Request::segment(3)): ?><?php echo e($vehicle_info_detail->inflation_front); ?><?php endif; ?>">
              </div>
            </div>
            <div class="col-md-4 tire_content">
              <label class="form-label">Inflation Rear</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <input type="text" class="form-control" name="inflation_rear" placeholder="e.g. 35psi"
                  value="<?php if(Request::segment(3)): ?><?php echo e($vehicle_info_detail->inflation_rear); ?><?php endif; ?>">
              </div>
            </div>
          <div class="col-md-4 wheel_content">
              <label class="form-label">Diameter</label>
              <div class="input-group">
                <span class="input-group-text"><i class="bi bi-archive"></i></span>
                <select class="form-select" name="center_hub_diameter">
                  <option value="" selected disabled>Select Diameter</option>
                  <?php $__currentLoopData = $diameter_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($dl->id); ?>" <?php if(Request::segment(3) && $vehicle_info_detail->center_hub_diameter == $dl->id): ?> selected <?php endif; ?>><?php echo e($dl->diameter); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>
            </div>


            <div class="col-12 text-end">
              <?php if(Request::segment(3)): ?>
          <button type="submit" class="btns btns-hover"><span><i class="bi bi-save me-1"></i> Update
            Info</span></button>
        <?php else: ?>
          <button type="submit" class="btns btns-hover"><span><i class="bi bi-save me-1"></i> Save
            Info</span></button>
        <?php endif; ?>
            </div>
          </div>
        </form>
    </div>
  </div>

</div>
</div>
<?php echo $__env->make('includes.admin_footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script>
  <?php if(Request::segment(3)): ?>
    var model = <?php echo e($vehicle_info_detail->model); ?>;
    getModel(<?php echo e($vehicle_info_detail->brand); ?>);
    var variant = <?php echo e($vehicle_info_detail->vehicle_variant); ?>;

  <?php else: ?>
    var model = '';
    var variant = '';
  <?php endif; ?>

  $('#productImageInput').on('change', function (event) {
    const file = event.target.files[0];
    if (file) {
      const reader = new FileReader();

      reader.onload = function (e) {
        $(".imgdiv").removeClass('d-none');
        $('#imagePreview').attr('src', e.target.result).show();
      };

      reader.readAsDataURL(file);
    }
  });

  function get_vehicle_variant() {
    $.ajaxSetup({
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
    });
    var postdata = {
      "year": $("#year").val(),
      "brand": $("#brand").val(),
      "model": $("#product_model").val(),
      "vehicle_type": $("#vehicle_type").val(),
    }
    $.ajax({
      url: '<?php echo e(url('/')); ?>/admin/get-vehicle-variant',
      type: 'POST',
      data: postdata,
      dataType: 'json',
      success: function (res) {
        if (res.status == true) {
          var html = `<option value="">Select Vehice variant</option>`;
          $.each(res.data, function (key, val) {
            if (val.id == variant) {
              var selected = 'selected';
            }
            else {
              var selected = '';
            }
            html += `<option value="` + val.id + `" ` + selected + `>` + val.variant + `</option>`;
          });
          $("#vehicle_variant").html(html);
        }
        else {
          Swal.fire({
            title: 'Error!',
            text: 'No variant for selected data',
            icon: 'error',
            confirmButtonText: 'OK'
          });
        }

      }
    });
  }

  function getModel(brand_id) {

    $.ajaxSetup({
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
    });
    var postdata = {
      "brand_id": brand_id
    }
    $.ajax({
      url: '<?php echo e(url('/')); ?>/admin/get-model-by-brand',
      type: 'POST',
      data: postdata,
      dataType: 'json',
      success: function (res) {
        if (res.status == true) {
          var html = `<option value="">Select Model</option>`;
          $.each(res.data, function (key, val) {
            if (val.id == model) {
              var selected = 'selected';
            }
            else {
              var selected = '';
            }
            html += `<option value="` + val.id + `" ` + selected + `>` + val.model_name + `</option>`;
          });
            $("#product_model").html(html);
            <?php if(Request::segment(3)): ?>
              get_vehicle_variant();
            <?php endif; ?>
          }
        else {
          Swal.fire({
            title: 'Error!',
            text: 'No model for selected brand',
            icon: 'error',
            confirmButtonText: 'OK'
          });
        }

      }
    });
  }
</script><?php /**PATH C:\xampp\htdocs\thetireshop\resources\views/admin/vehicle_info.blade.php ENDPATH**/ ?>