<?php echo $__env->make('includes.admin_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="d-flex" id="wrapper">
  <!-- Sidebar -->
  <?php echo $__env->make('includes.admin_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Main Content -->
    <div class="container-fluid px-4 py-4">
      <!-- Dashboard Cards -->
       <div class="container ">
            <div class="row">
            <div class="col-md-6">
                <h2 class="mb-4"><i class="bi bi-box2-fill me-2"></i>Inventory List</h2>
            </div>
            <div class="col-md-6" style="text-align: right;">
                <a href="<?php echo e(url('admin/manage-inventory')); ?>" class="btn btn-primary">Add new Inventory</a>
            </div>
        </div>
      <div class="row g-4">
            <div class="table-responsive bg-white p-4 rounded shadow-sm">
      <h5 class="mb-3">Current Inventory</h5>
      <table class="table align-middle table-bordered invt">
        <thead class="table-light">
          <tr>
            <th>#</th>
            <th>Description</th>
            <th>SKU</th>
            <th>Size</th>
            <th>Product Type</th>
            <th>Category</th>
            <th>Stock</th>
            <th>Main Price</th>
            <th>Offer Price</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $productdata; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
        <td><?php echo e($key + 1); ?></td>
        <td><?php echo e($p->title); ?></td>
        <td><?php echo e($p->sku); ?></td>
        <?php if($p->category == 'Tire'): ?>
        <td><?php echo e($p->size); ?></td>
        <?php elseif($p->category == 'Wheels'): ?>
        <td><?php echo e($p->rim_size); ?></td>
        <?php else: ?>
        <td>NA</td>
        <?php endif; ?>
        <td><?php echo e($p->product_type); ?></td>
        <td><span class="badge <?php if($p->category == 'Tire'): ?> bg-primary <?php elseif($p->category == 'Wheels'): ?> bg-warning <?php else: ?> bg-info <?php endif; ?>"><i
            class="bi bi-circle-fill me-1"></i><?php echo e($p->category); ?></span></td>
        <td><?php echo e($p->stock_qty); ?></td>
        <td><?php echo e($p->main_price); ?></td>
        <td><?php echo e($p->offer_price); ?></td>
        <td>
          <a href="<?php echo e(url('/')); ?>/admin/edit-product/<?php echo e($p->id); ?>" class="btn btn-sm btn-outline-info"><i
            class="bi bi-pencil"></i></a>
          <button class="btn btn-sm btn-outline-danger" onclick="confirmDelete(<?php echo e($p->id); ?>)"><i
            class="bi bi-trash"></i></button>
        </td>
        </tr>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
    </div>
    </div>
  </div>
</div>
</div>
</div>
<?php echo $__env->make('includes.admin_footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script>
  function confirmDelete(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "This action cannot be undone.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {

              $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                var postdata = {
                  "id":id
                }
                  $.ajax({
                      url: '<?php echo e(url('/')); ?>/admin/delete-product',
                      type: 'POST',
                      data: postdata,
                      dataType: 'json',
                      success: function (res) {
                        if(res.status == false)
                        {
                            Swal.fire({
                                title: 'Error!',
                                text: 'Something went wrong',
                                icon: 'warning',
                                confirmButtonText: 'OK'
                            });
                        }
                        else
                        {
                            Swal.fire({
                                title: 'Success!',
                                text: 'Data deleted successfully.',
                                icon: 'success',
                                confirmButtonText: 'OK'
                                }).then((result) => {
                                if (result.isConfirmed) {
                                    location.reload();
                                }
                            });
                        }

                      }
                  });
                
            }
        });
    }
</script>
<?php /**PATH /home/ecommerceseo/public_html/thetireshop/resources/views/admin/product.blade.php ENDPATH**/ ?>