<?php echo $__env->make('includes.admin_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="d-flex" id="wrapper">
  <!-- Sidebar -->
  <?php echo $__env->make('includes.admin_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Main Content -->
  <div class="container-fluid py-4 px-4 order-s">
        <div class="row">
            <div class="col-md-6">
                <h2 class="mb-4"><i class="bi bi-box2-fill me-2"></i>Dealer</h2>
            </div>
            <div class="col-md-6" style="text-align: right;">
                <a href="<?php echo e(url('admin/manage-dealer')); ?>" class="btn btn-primary">Add new Dealer</a>
            </div>
        </div>
    <!--<div class="d-flex justify-content-between align-items-center mb-4">-->
    <!--  <h2><i class="bi bi-shop me-2"></i>Dealer</h2>-->
    <!--</div>-->
    <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible">
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                <?php echo e(session('error')); ?>

        </div>
        <?php endif; ?>
        <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible">
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>
    <!-- Add Dealer Form -->
    <div class="card p-4 mb-4">
      <h5 class="mb-3"><i class="bi bi-plus-circle me-2 text-success"></i>Add New Dealer</h5>
      <?php if(Request::segment(3)): ?>
      <form action="<?php echo e(route('update-admin-dealer')); ?>" method="post" enctype="multipart/form-data">
      <input type="hidden" name="id" value="<?php if(Request::segment(3)): ?> <?php echo e($dealer_detail->id); ?>  <?php endif; ?>">
      <input type="hidden" name="hidden_image" value="<?php if(Request::segment(3)): ?> <?php echo e($dealer_detail->image); ?>  <?php endif; ?>">
      <?php else: ?>
      <form action="<?php echo e(route('save-admin-dealer')); ?>" method="post" enctype="multipart/form-data">
        <?php endif; ?>
      <?php echo csrf_field(); ?>
      <div class="row">
        <div class="col-md-12">
            <div class="mb-3">
            <label for="business_name" class="form-label">Business Name</label>
            <input type="text" class="form-control" id="business_name" name="business_name" value="<?php if(Request::segment(3)): ?><?php echo e($dealer_detail->business_name); ?><?php endif; ?>" required />
            </div>
        </div>
        <div class="col-md-4">
            <div class="mb-3">
            <label for="primary_business" class="form-label">What is your primary business?</label>
            <select class="form-control" name="primary_business" id="primary_business">
            <option value="">Select business</option>                 
            <option value="Tire Retailer" <?php if(Request::segment(3) && $dealer_detail->primary_business == 'Tire Retailer'): ?> selected  <?php endif; ?>>Tire Retailer</option>
            <option value="Tire Wholesaler" <?php if(Request::segment(3) && $dealer_detail->primary_business == 'Tire Wholesaler'): ?> selected  <?php endif; ?>>Tire Wholesaler</option>
            <option value="Auto Service" <?php if(Request::segment(3) && $dealer_detail->primary_business == 'Auto Service'): ?> selected  <?php endif; ?>>Auto Service</option>
            </select>
            </div>
        </div>
        <div class="col-md-4">
            <div class="mb-3">
            <label for="company_size" class="form-label">Company size</label>
            <select class="form-control" name="company_size" id="company_size">
            <option value="">Select size</option>                 
            <option value="1 - 5" aria-selected="false" <?php if(Request::segment(3) && $dealer_detail->company_size == '1 - 5'): ?> selected  <?php endif; ?>>1 - 5</option>
            <option value="5 - 10" aria-selected="false" <?php if(Request::segment(3) && $dealer_detail->company_size == '5 - 10'): ?> selected  <?php endif; ?>>5 - 10</option>
            <option value="10 - 25" aria-selected="false" <?php if(Request::segment(3) && $dealer_detail->company_size == '10 - 25'): ?> selected  <?php endif; ?>>10 - 25</option>
            <option value="25 - 50" aria-selected="false" <?php if(Request::segment(3) && $dealer_detail->company_size == '25 - 50'): ?> selected  <?php endif; ?>>25 - 50</option>
            <option value="50 - 100" aria-selected="false" <?php if(Request::segment(3) && $dealer_detail->company_size == '50 - 100'): ?> selected  <?php endif; ?>>50 - 100</option>
            <option value="100+" aria-selected="false" <?php if(Request::segment(3) && $dealer_detail->company_size == '100+'): ?> selected  <?php endif; ?>>100+</option>
            </select>
            </div>
        </div>
        <div class="col-md-4">
            <div class="mb-3">
            <label for="position" class="form-label">Position</label>
            <input type="text" class="form-control" name="position" id="position" value="<?php if(Request::segment(3)): ?><?php echo e($dealer_detail->position); ?><?php endif; ?>" required />
            </div>
        </div>
        <div class="col-md-4">
            <div class="mb-3">
            <label for="name" class="form-label">Name</label>
            <input type="text" class="form-control" name="name" id="name" value="<?php if(Request::segment(3)): ?><?php echo e($dealer_detail->name); ?><?php endif; ?>" required />
            </div>
        </div>
        <div class="col-md-4">
            <div class="mb-3">
            <label for="email" class="form-label">Email address</label>
            <input type="email" class="form-control" name="email" id="email" value="<?php if(Request::segment(3)): ?><?php echo e($dealer_detail->email); ?><?php endif; ?>" required />
            </div>
        </div>
        <div class="col-md-4">
            <div class="mb-3">
            <label for="password" class="form-label">Password</label>
            <input type="text" class="form-control" name="password" id="password" value="<?php if(Request::segment(3)): ?><?php echo e($dealer_detail->text_password); ?><?php endif; ?>" required />
            </div>
        </div>
        <div class="col-md-4">
            <div class="mb-3">
            <label for="phone" class="form-label">Phone Number</label>
            <input type="tel" class="form-control" name="phone" id="phone" value="<?php if(Request::segment(3)): ?><?php echo e($dealer_detail->phone); ?><?php endif; ?>" required />
            </div>
        </div>
        <div class="col-md-4">
            <div class="mb-3">
            <label for="address" class="form-label">Address</label>
            <input type="text" class="form-control" name="address" id="address" value="<?php if(Request::segment(3)): ?><?php echo e($dealer_detail->address); ?><?php endif; ?>" required />
            </div>
        </div>
        <div class="col-md-4">
            <div class="mb-3">
            <label for="city" class="form-label">City</label>
            <input type="text" class="form-control" name="city" id="city" value="<?php if(Request::segment(3)): ?><?php echo e($dealer_detail->city); ?><?php endif; ?>" required />
            </div>
        </div>
        <div class="col-md-4">
            <div class="mb-3">
            <label for="province" class="form-label">Province</label>
            <input type="text" class="form-control" name="province" id="province" value="<?php if(Request::segment(3)): ?><?php echo e($dealer_detail->province); ?><?php endif; ?>" required />
            </div>
        </div>
        <div class="col-md-4">
            <div class="mb-3">
            <label for="postal_code" class="form-label">Postal code</label>
            <input type="text" class="form-control" name="postal_code" id="postal_code" value="<?php if(Request::segment(3)): ?><?php echo e($dealer_detail->postal_code); ?><?php endif; ?>" required />
            </div>
        </div>
        <div class="col-md-4">
            <div class="mb-3">
            <label for="status" class="form-label">Status</label>
            <select class="form-control" name="status" id="status">
            <option value="">Select status</option>                 
            <option value="active" <?php if(Request::segment(3) && $dealer_detail->status == 'active'): ?> selected  <?php endif; ?>>Active</option>
            <option value="inactive" <?php if(Request::segment(3) && $dealer_detail->status == 'inactive'): ?> selected  <?php endif; ?>>Inactive</option>
            </select>
            </div>
        </div>
        <div class="col-md-12">
            <div class="mb-3">
            <label for="message" class="form-label">Message</label>
            <textarea class="form-control" id="message" name="message"><?php if(Request::segment(3)): ?><?php echo e($dealer_detail->message); ?><?php endif; ?></textarea>
            </div>
        </div>
      </div>
        <div class="mt-3">
        <?php if(Request::segment(3)): ?>
          <button type="submit" class="btns btns-hover"><span><i class="bi bi-save me-1"></i> Update Product</span></button>
          <?php else: ?>
            <button type="submit" class="btns btns-hover"><span><i class="bi bi-save me-1"></i> Save Product</span></button>
          <?php endif; ?>
        </div>
      </form>
    </div>

    <!-- Dealer List -->
    <div class="table-responsive bg-white p-4 rounded shadow-sm">
      <h5 class="mb-3">Dealer List</h5>
      <table class="table align-middle table-bordered invt">
        <thead class="table-light">
          <tr>
            <th>#</th>
            <th>Image</th>
            <th>Name</th>
            <th>Business name</th>
            <th>Primary business</th>
            <th>Email</th>
            <th>Phone</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
           <?php $__currentLoopData = $dealerdata; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
            <td><?php echo e($key+1); ?></td>
            <td><img src="<?php echo e(url('/')); ?>/assets/images/infantry.avif" alt="Wheel" /></td>
            <td><?php echo e($d->name); ?></td>
            <td><?php echo e($d->business_name); ?></td>
            <td><?php echo e($d->primary_business); ?></td>
            <td><?php echo e($d->email); ?></td>
            <td><?php echo e($d->phone); ?></td>
            <td>
              <a href="<?php echo e(url('/')); ?>/admin/edit-dealer/<?php echo e($d->id); ?>" class="btn btn-sm btn-outline-info"><i class="bi bi-pencil"></i></a>
              <button class="btn btn-sm btn-outline-danger" onclick="confirmDelete(<?php echo e($d->id); ?>)"><i class="bi bi-trash"></i></button>
            </td>
          </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
    </div>
  </div>

  </div>
</div>
</div>
<?php echo $__env->make('includes.admin_footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script>
  $('#productImageInput').on('change', function(event) {
    const file = event.target.files[0];
    if (file) {
        const reader = new FileReader();

        reader.onload = function(e) {
            $('#imagePreview').attr('src', e.target.result).show();
        };

        reader.readAsDataURL(file);
    }
});



function confirmDelete(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "This action cannot be undone.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {

              $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                var postdata = {
                  "id":id
                }
                  $.ajax({
                      url: '<?php echo e(url('/')); ?>/admin/delete-dealer',
                      type: 'POST',
                      data: postdata,
                      dataType: 'json',
                      success: function (res) {
                        if(res.status == false)
                        {
                            Swal.fire({
                                title: 'Error!',
                                text: 'Something went wrong',
                                icon: 'warning',
                                confirmButtonText: 'OK'
                            });
                        }
                        else
                        {
                            Swal.fire({
                                title: 'Success!',
                                text: 'Data deleted successfully.',
                                icon: 'success',
                                confirmButtonText: 'OK'
                                }).then((result) => {
                                if (result.isConfirmed) {
                                    location.href = '<?php echo e(url('/')); ?>/admin/manage-dealer';
                                }
                            });
                        }

                      }
                  });
                
            }
        });
    }

</script><?php /**PATH /home/ecommerceseo/public_html/thetireshop/resources/views/admin/dealer.blade.php ENDPATH**/ ?>