<?php echo $__env->make('includes.admin_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="d-flex" id="wrapper">
  <!-- Sidebar -->
  <?php echo $__env->make('includes.admin_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Main Content -->
    <div class="container-fluid px-4 py-4">
      <!-- Dashboard Cards -->
       <div class="container ">
        <div class="d-flex justify-content-between align-items-center mb-4">
          <h2><i class="bi bi-box-seam me-2"></i>Vehicle Dashboard</h2>
          <a href="<?php echo e(url('/')); ?>/admin/manage-vehicle-info" class="btns btns-hover"><span><i class="bi bi-plus-circle me-1"></i>Add New Vehicle</span></a>
        </div>
      <div class="row g-4">
            <div class="table-responsive bg-white p-4 rounded shadow-sm">
      <h5 class="mb-3">Current Vehicle</h5>
      <table class="table align-middle table-bordered invt datatable">
        <thead class="table-light">
          <tr>
            <th>#</th>
            <th>Brand</th>
            <th>Model</th>
            <th>Variant</th>
            <th>Vehicle Type</th>
            <th>Rim Size</th>
            <th>Tire Size</th>
            <th>Load Speed</th>
            <th>OD Value</th>
            <th>Bolt Circle</th>
            <th>Offset Distance</th>
            <th>Inflation</th>
            <th>Diameter</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $vehicle_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
        <td><?php echo e($key + 1); ?></td>
        <td><?php echo e($p->brand_name); ?></td>
        <td><?php echo e($p->model_name); ?></td>
        <td><?php echo e($p->vehicle_variant); ?></td>
        <td><?php echo e($p->vehicle_type); ?></td>
        <td><?php echo e($p->rim_size); ?></td>
        <td><?php echo e($p->size); ?></td>
        <td><?php echo e($p->load_speed); ?></td>
        <td><?php echo e($p->od_value); ?></td>
        <td><?php echo e($p->bolt_circle); ?></td>
        <td><?php echo e($p->offset_distance); ?></td>
        <td><p>Front : <?php echo e($p->inflation_front); ?></p><p>Rear : <?php echo e($p->inflation_rear); ?></p></td>
        <td><?php echo e($p->diameter); ?></td>
        <td>
          <a href="<?php echo e(url('/')); ?>/admin/edit-vehicle-info/<?php echo e($p->id); ?>" class="btn btn-sm btn-outline-info"><i
            class="bi bi-pencil"></i></a>
          <button class="btn btn-sm btn-outline-danger" onclick="confirmDelete(<?php echo e($p->id); ?>)"><i
            class="bi bi-trash"></i></button>
        </td>
        </tr>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
    </div>
    </div>
  </div>
</div>
</div>
</div>
<?php echo $__env->make('includes.admin_footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script>
  function confirmDelete(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "This action cannot be undone.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {

              $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                var postdata = {
                  "id":id
                }
                  $.ajax({
                      url: '<?php echo e(url('/')); ?>/admin/delete-vehicle-info',
                      type: 'POST',
                      data: postdata,
                      dataType: 'json',
                      success: function (res) {
                        if(res.status == false)
                        {
                            Swal.fire({
                                title: 'Error!',
                                text: 'Something went wrong',
                                icon: 'warning',
                                confirmButtonText: 'OK'
                            });
                        }
                        else
                        {
                            Swal.fire({
                                title: 'Success!',
                                text: 'Data deleted successfully.',
                                icon: 'success',
                                confirmButtonText: 'OK'
                                }).then((result) => {
                                if (result.isConfirmed) {
                                    location.reload();
                                }
                            });
                        }

                      }
                  });
                
            }
        });
    }
</script>
<?php /**PATH /home/ecommerceseo/public_html/thetireshop/resources/views/admin/vehicle_list.blade.php ENDPATH**/ ?>