<?php echo $__env->make('includes.admin_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="d-flex" id="wrapper">
  <!-- Sidebar -->
  <?php echo $__env->make('includes.admin_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Main Content -->
  <div class="container-fluid py-4 px-4 order-s">
    <!--<div class="d-flex justify-content-between align-items-center mb-4">-->
    <!--  <h2><i class="bi bi-receipt me-2"></i>Orders</h2>-->
    <!--  <button class="btns btns-hover"><span><i class="bi bi-plus-circle me-1"></i> New Order</span></button>-->
    <!--</div>-->

    <div class="table-responsive shadow-sm rounded bg-white p-3">
      <table class="table align-middle table-hover">
        <thead class="table-light">
          <tr>
            <th>#</th>
            <th>Order Id</th>
            <th>Name</th>
            <th>Contact Name</th>
            <th>Order Date</th>
            <th>Address</th>
            <th>Sub Total</th>
            <th>HST</th>
            <th>Total Amount</th>
            <th>Total Item</th>
            <th>Status</th>
            <th>View Product</th>
          </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $orderdata; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
        <td><?php echo e($key + 1); ?></td>
        <td><?php echo e($p->order_id); ?></td>
        <td><?php echo e($p->shipping_name); ?></td>
        <td><?php echo e($p->shipping_contact); ?></td>
        <td><?php echo e($p->order_date); ?></td>
        <td><?php echo e($p->shipping_address); ?></td>
        <td><?php echo e($p->sub_total_amount); ?></td>
        <td><?php echo e($p->hst_amount); ?></td>
        <td><?php echo e($p->total_amount); ?></td>
        <td><?php echo e($p->total_item); ?></td>
        <td><span class="badge <?php if($p->status == 'received'): ?> bg-primary <?php else: ?> bg-success <?php endif; ?>"><i
            class="bi bi-circle-fill me-1"></i><?php echo e($p->status); ?></span></td>
        <td>
          <button class="btn btn-sm btn-outline-danger" title="View Order Product" onclick="get_order_product('<?php echo e($p->order_id); ?>')"><i
            class="bi bi-eye"></i></button>
        </td>
        </tr>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
</div>

<!-- The Modal -->
<div class="modal" id="productModal">
  <div class="modal-dialog" style="max-width: fit-content;">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h4 class="modal-title">Order Product</h4>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <!-- Modal body -->
      <div class="modal-body">
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive shadow-sm rounded bg-white p-3">
                        <table class="table align-middle table-hover">
                            <thead class="table-light">
                              <tr>
                                <th>#</th>
                                <th>Order Id</th>
                                <th>Product Name</th>
                                <th>Size</th>
                                <th>SKU</th>
                                <th>Qty</th>
                                <th>OSTF</th>
                                <th>Price</th>
                                <th>Total Price</th>
                                <th>Category</th>
                              </tr>
                            </thead>
                            <tbody id="product_list">
                                
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
      </div>

      <!-- Modal footer -->
      <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Close</button>
      </div>

    </div>
  </div>
</div>


<?php echo $__env->make('includes.admin_footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script>
function get_order_product(order_id)
{

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        var postdata = {
          "order_id":order_id
        }
        $.ajax({
              url: '<?php echo e(url('/')); ?>/admin/get-order-product',
              type: 'POST',
              data: postdata,
              dataType: 'json',
              success: function (res) {
                    var html=``;
                    var i=1;
                    $.each(res, function(key,val) {
                        html += `<tr>
                                    <td>`+i+`</td>
                                    <td>`+val.order_id+`</td>
                                    <td>`+val.product_name+`</td>`;
                                    if(val.product_category == 'Tire')
                                    {
                                         html += `<td>`+val.size+`</td>`;
                                    }
                                    else if(val.product_category == 'Wheels')
                                    {
                                        html += `<td>`+val.rim_size+`</td>`;
                                    }
                                    else
                                    {
                                        html += `<td>NA</td>`;
                                    }
                                    html += `<td>`+val.sku+`</td>
                                    <td>`+val.qty+`</td>
                                    <td>`+val.otsf_fee+`</td>
                                    <td>`+val.price+`</td>
                                    <td>`+val.total_price+`</td>
                                    <td>`+val.product_category+`</td>
                                  </tr>`;
                        i++;
                    });
                    $("#product_list").html(html);
                    $("#productModal").modal('show');

              }
        });
}
</script>
<?php /**PATH /home/ecommerceseo/public_html/thetireshop/resources/views/admin/order.blade.php ENDPATH**/ ?>